/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  DeleteNewsParams,
  GetNewsAdminParams,
  GetNewsParams,
  News,
  Response
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Get
 */
export type getNewsIdResponse200 = {
  data: Response
  status: 200
}
    
export type getNewsIdResponseSuccess = (getNewsIdResponse200) & {
  headers: Headers;
};
;

export type getNewsIdResponse = (getNewsIdResponseSuccess)

export const getGetNewsIdUrl = (id: string,) => {


  

  return `/news/${id}`
}

export const getNewsId = async (id: string, options?: RequestInit): Promise<getNewsIdResponse> => {
  
  return useCustomClient<getNewsIdResponse>(getGetNewsIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetNewsIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/news/${id}`
    ] as const;
    }

export const getGetNewsIdQueryKey = (id?: string,) => {
    return [
    `/news/${id}`
    ] as const;
    }

    
export const getGetNewsIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getNewsId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsId>>> = ({ signal }) => getNewsId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsId>>>
export type GetNewsIdInfiniteQueryError = ErrorType<unknown>


export function useGetNewsIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsId>>,
          TError,
          Awaited<ReturnType<typeof getNewsId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsId>>,
          TError,
          Awaited<ReturnType<typeof getNewsId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getNewsId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetNewsIdQueryOptions = <TData = Awaited<ReturnType<typeof getNewsId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsId>>> = ({ signal }) => getNewsId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsIdQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsId>>>
export type GetNewsIdQueryError = ErrorType<unknown>


export function useGetNewsId<TData = Awaited<ReturnType<typeof getNewsId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsId>>,
          TError,
          Awaited<ReturnType<typeof getNewsId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsId<TData = Awaited<ReturnType<typeof getNewsId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsId>>,
          TError,
          Awaited<ReturnType<typeof getNewsId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsId<TData = Awaited<ReturnType<typeof getNewsId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsId<TData = Awaited<ReturnType<typeof getNewsId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsIdQuery = async <TData = Awaited<ReturnType<typeof getNewsId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putNewsIdResponse200 = {
  data: Response
  status: 200
}
    
export type putNewsIdResponseSuccess = (putNewsIdResponse200) & {
  headers: Headers;
};
;

export type putNewsIdResponse = (putNewsIdResponseSuccess)

export const getPutNewsIdUrl = (id: string,) => {


  

  return `/news/${id}`
}

export const putNewsId = async (id: string,
    news: News, options?: RequestInit): Promise<putNewsIdResponse> => {
  
  return useCustomClient<putNewsIdResponse>(getPutNewsIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      news,)
  }
);}




export const getPutNewsIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putNewsId>>, TError,{id: string;data: BodyType<News>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putNewsId>>, TError,{id: string;data: BodyType<News>}, TContext> => {

const mutationKey = ['putNewsId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putNewsId>>, {id: string;data: BodyType<News>}> = (props) => {
          const {id,data} = props ?? {};

          return  putNewsId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutNewsIdMutationResult = NonNullable<Awaited<ReturnType<typeof putNewsId>>>
    export type PutNewsIdMutationBody = BodyType<News>
    export type PutNewsIdMutationError = ErrorType<unknown>

    export const usePutNewsId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putNewsId>>, TError,{id: string;data: BodyType<News>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putNewsId>>,
        TError,
        {id: string;data: BodyType<News>},
        TContext
      > => {

      const mutationOptions = getPutNewsIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteNewsIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteNewsIdResponseSuccess = (deleteNewsIdResponse200) & {
  headers: Headers;
};
;

export type deleteNewsIdResponse = (deleteNewsIdResponseSuccess)

export const getDeleteNewsIdUrl = (id: string,) => {


  

  return `/news/${id}`
}

export const deleteNewsId = async (id: string, options?: RequestInit): Promise<deleteNewsIdResponse> => {
  
  return useCustomClient<deleteNewsIdResponse>(getDeleteNewsIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteNewsIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteNewsId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteNewsId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteNewsId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteNewsId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteNewsId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteNewsIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteNewsId>>>
    
    export type DeleteNewsIdMutationError = ErrorType<unknown>

    export const useDeleteNewsId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteNewsId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteNewsId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteNewsIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getNewsAdminResponse200 = {
  data: Response
  status: 200
}
    
export type getNewsAdminResponseSuccess = (getNewsAdminResponse200) & {
  headers: Headers;
};
;

export type getNewsAdminResponse = (getNewsAdminResponseSuccess)

export const getGetNewsAdminUrl = (params?: GetNewsAdminParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/news/admin?${stringifiedParams}` : `/news/admin`
}

export const getNewsAdmin = async (params?: GetNewsAdminParams, options?: RequestInit): Promise<getNewsAdminResponse> => {
  
  return useCustomClient<getNewsAdminResponse>(getGetNewsAdminUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetNewsAdminInfiniteQueryKey = (params?: GetNewsAdminParams,) => {
    return [
    'infinite', `/news/admin`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetNewsAdminQueryKey = (params?: GetNewsAdminParams,) => {
    return [
    `/news/admin`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetNewsAdminInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getNewsAdmin>>>, TError = ErrorType<unknown>>(params?: GetNewsAdminParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsAdminInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsAdmin>>> = ({ signal }) => getNewsAdmin(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsAdminInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsAdmin>>>
export type GetNewsAdminInfiniteQueryError = ErrorType<unknown>


export function useGetNewsAdminInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsAdmin>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetNewsAdminParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsAdmin>>,
          TError,
          Awaited<ReturnType<typeof getNewsAdmin>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsAdminInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsAdmin>>>, TError = ErrorType<unknown>>(
 params?: GetNewsAdminParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsAdmin>>,
          TError,
          Awaited<ReturnType<typeof getNewsAdmin>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsAdminInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsAdmin>>>, TError = ErrorType<unknown>>(
 params?: GetNewsAdminParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsAdminInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsAdmin>>>, TError = ErrorType<unknown>>(
 params?: GetNewsAdminParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsAdminInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsAdminInfiniteQuery = async <TData = Awaited<ReturnType<typeof getNewsAdmin>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetNewsAdminParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsAdminInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetNewsAdminQueryOptions = <TData = Awaited<ReturnType<typeof getNewsAdmin>>, TError = ErrorType<unknown>>(params?: GetNewsAdminParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsAdminQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsAdmin>>> = ({ signal }) => getNewsAdmin(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsAdminQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsAdmin>>>
export type GetNewsAdminQueryError = ErrorType<unknown>


export function useGetNewsAdmin<TData = Awaited<ReturnType<typeof getNewsAdmin>>, TError = ErrorType<unknown>>(
 params: undefined |  GetNewsAdminParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsAdmin>>,
          TError,
          Awaited<ReturnType<typeof getNewsAdmin>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsAdmin<TData = Awaited<ReturnType<typeof getNewsAdmin>>, TError = ErrorType<unknown>>(
 params?: GetNewsAdminParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsAdmin>>,
          TError,
          Awaited<ReturnType<typeof getNewsAdmin>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsAdmin<TData = Awaited<ReturnType<typeof getNewsAdmin>>, TError = ErrorType<unknown>>(
 params?: GetNewsAdminParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsAdmin<TData = Awaited<ReturnType<typeof getNewsAdmin>>, TError = ErrorType<unknown>>(
 params?: GetNewsAdminParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsAdminQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsAdminQuery = async <TData = Awaited<ReturnType<typeof getNewsAdmin>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetNewsAdminParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsAdminQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getNewsResponse200 = {
  data: Response
  status: 200
}
    
export type getNewsResponseSuccess = (getNewsResponse200) & {
  headers: Headers;
};
;

export type getNewsResponse = (getNewsResponseSuccess)

export const getGetNewsUrl = (params?: GetNewsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/news?${stringifiedParams}` : `/news`
}

export const getNews = async (params?: GetNewsParams, options?: RequestInit): Promise<getNewsResponse> => {
  
  return useCustomClient<getNewsResponse>(getGetNewsUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetNewsInfiniteQueryKey = (params?: GetNewsParams,) => {
    return [
    'infinite', `/news`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetNewsQueryKey = (params?: GetNewsParams,) => {
    return [
    `/news`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetNewsInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getNews>>>, TError = ErrorType<unknown>>(params?: GetNewsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNews>>> = ({ signal }) => getNews(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getNews>>>
export type GetNewsInfiniteQueryError = ErrorType<unknown>


export function useGetNewsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNews>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetNewsParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNews>>,
          TError,
          Awaited<ReturnType<typeof getNews>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNews>>>, TError = ErrorType<unknown>>(
 params?: GetNewsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNews>>,
          TError,
          Awaited<ReturnType<typeof getNews>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNews>>>, TError = ErrorType<unknown>>(
 params?: GetNewsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNews>>>, TError = ErrorType<unknown>>(
 params?: GetNewsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsInfiniteQuery = async <TData = Awaited<ReturnType<typeof getNews>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetNewsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetNewsQueryOptions = <TData = Awaited<ReturnType<typeof getNews>>, TError = ErrorType<unknown>>(params?: GetNewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNews>>> = ({ signal }) => getNews(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsQueryResult = NonNullable<Awaited<ReturnType<typeof getNews>>>
export type GetNewsQueryError = ErrorType<unknown>


export function useGetNews<TData = Awaited<ReturnType<typeof getNews>>, TError = ErrorType<unknown>>(
 params: undefined |  GetNewsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNews>>,
          TError,
          Awaited<ReturnType<typeof getNews>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNews<TData = Awaited<ReturnType<typeof getNews>>, TError = ErrorType<unknown>>(
 params?: GetNewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNews>>,
          TError,
          Awaited<ReturnType<typeof getNews>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNews<TData = Awaited<ReturnType<typeof getNews>>, TError = ErrorType<unknown>>(
 params?: GetNewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNews<TData = Awaited<ReturnType<typeof getNews>>, TError = ErrorType<unknown>>(
 params?: GetNewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsQuery = async <TData = Awaited<ReturnType<typeof getNews>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetNewsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNews>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postNewsResponse200 = {
  data: Response
  status: 200
}
    
export type postNewsResponseSuccess = (postNewsResponse200) & {
  headers: Headers;
};
;

export type postNewsResponse = (postNewsResponseSuccess)

export const getPostNewsUrl = () => {


  

  return `/news`
}

export const postNews = async (news: News[], options?: RequestInit): Promise<postNewsResponse> => {
  
  return useCustomClient<postNewsResponse>(getPostNewsUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      news,)
  }
);}




export const getPostNewsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postNews>>, TError,{data: BodyType<News[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postNews>>, TError,{data: BodyType<News[]>}, TContext> => {

const mutationKey = ['postNews'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postNews>>, {data: BodyType<News[]>}> = (props) => {
          const {data} = props ?? {};

          return  postNews(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostNewsMutationResult = NonNullable<Awaited<ReturnType<typeof postNews>>>
    export type PostNewsMutationBody = BodyType<News[]>
    export type PostNewsMutationError = ErrorType<unknown>

    export const usePostNews = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postNews>>, TError,{data: BodyType<News[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postNews>>,
        TError,
        {data: BodyType<News[]>},
        TContext
      > => {

      const mutationOptions = getPostNewsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteNewsResponse200 = {
  data: Response
  status: 200
}
    
export type deleteNewsResponseSuccess = (deleteNewsResponse200) & {
  headers: Headers;
};
;

export type deleteNewsResponse = (deleteNewsResponseSuccess)

export const getDeleteNewsUrl = (params: DeleteNewsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/news?${stringifiedParams}` : `/news`
}

export const deleteNews = async (params: DeleteNewsParams, options?: RequestInit): Promise<deleteNewsResponse> => {
  
  return useCustomClient<deleteNewsResponse>(getDeleteNewsUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteNewsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteNews>>, TError,{params: DeleteNewsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteNews>>, TError,{params: DeleteNewsParams}, TContext> => {

const mutationKey = ['deleteNews'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteNews>>, {params: DeleteNewsParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteNews(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteNewsMutationResult = NonNullable<Awaited<ReturnType<typeof deleteNews>>>
    
    export type DeleteNewsMutationError = ErrorType<unknown>

    export const useDeleteNews = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteNews>>, TError,{params: DeleteNewsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteNews>>,
        TError,
        {params: DeleteNewsParams},
        TContext
      > => {

      const mutationOptions = getDeleteNewsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    