import Image from 'next/image'
import { Button, Card } from '@/components/ui'

export default function Home() {
  return (
    <div className="flex min-h-screen items-center justify-center bg-zinc-50 font-sans dark:bg-black">
      <main className="flex min-h-screen w-full max-w-3xl flex-col items-center justify-between py-32 px-16 bg-white dark:bg-black sm:items-start">
        <Image className="dark:invert" src="/next.svg" alt="Next.js logo" width={100} height={20} priority />

        <div className="flex flex-col items-center gap-6 text-center sm:items-start sm:text-left">
          <h1 className="max-w-xs text-3xl font-semibold leading-10 tracking-tight text-primary dark:text-zinc-50">
            To get started, edit the page.tsx file.
          </h1>
          <p className="max-w-md text-lg leading-8 text-zinc-600 dark:text-zinc-400">
            Looking for a starting point or more instructions? Head over to{' '}
            <a href="https://vercel.com/templates?framework=next.js" className="font-medium text-zinc-950 dark:text-zinc-50">
              Templates
            </a>{' '}
            or the{' '}
            <a href="https://nextjs.org/learn?utm_source=create-next-app" className="font-medium text-zinc-950 dark:text-zinc-50">
              Learning
            </a>{' '}
            center.
          </p>
        </div>

        <div className="flex w-full gap-4 text-base font-medium sm:flex-row">
          <Card className="flex-1 md:w-[158px]">
            <a href="https://vercel.com/new?utm_source=create-next-app" target="_blank" rel="noopener noreferrer">
              <Button className="w-full" variant="secondary">
                <Image className="dark:invert" src="/vercel.svg" alt="Vercel logomark" width={16} height={16} />
                <span className="ml-2">Deploy Now</span>
              </Button>
            </a>
          </Card>

          <Card className="flex-1 md:w-[158px]">
            <a href="https://nextjs.org/docs?utm_source=create-next-app" target="_blank" rel="noopener noreferrer">
              <Button className="w-full" variant="outline">
                Documentation
              </Button>
            </a>
          </Card>
        </div>
      </main>
    </div>
  )
}
