/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  DeleteConfigParams,
  GetConfigParams,
  PutConfigParams,
  Response,
  WebConfig
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Get
 */
export type getConfigResponse200 = {
  data: Response
  status: 200
}
    
export type getConfigResponseSuccess = (getConfigResponse200) & {
  headers: Headers;
};
;

export type getConfigResponse = (getConfigResponseSuccess)

export const getGetConfigUrl = (params?: GetConfigParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/config?${stringifiedParams}` : `/config`
}

export const getConfig = async (params?: GetConfigParams, options?: RequestInit): Promise<getConfigResponse> => {
  
  return useCustomClient<getConfigResponse>(getGetConfigUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetConfigInfiniteQueryKey = (params?: GetConfigParams,) => {
    return [
    'infinite', `/config`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetConfigQueryKey = (params?: GetConfigParams,) => {
    return [
    `/config`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetConfigInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getConfig>>>, TError = ErrorType<unknown>>(params?: GetConfigParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetConfigInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getConfig>>> = ({ signal }) => getConfig(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetConfigInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getConfig>>>
export type GetConfigInfiniteQueryError = ErrorType<unknown>


export function useGetConfigInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getConfig>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetConfigParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getConfig>>,
          TError,
          Awaited<ReturnType<typeof getConfig>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetConfigInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getConfig>>>, TError = ErrorType<unknown>>(
 params?: GetConfigParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getConfig>>,
          TError,
          Awaited<ReturnType<typeof getConfig>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetConfigInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getConfig>>>, TError = ErrorType<unknown>>(
 params?: GetConfigParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetConfigInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getConfig>>>, TError = ErrorType<unknown>>(
 params?: GetConfigParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetConfigInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetConfigInfiniteQuery = async <TData = Awaited<ReturnType<typeof getConfig>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetConfigParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetConfigInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetConfigQueryOptions = <TData = Awaited<ReturnType<typeof getConfig>>, TError = ErrorType<unknown>>(params?: GetConfigParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetConfigQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getConfig>>> = ({ signal }) => getConfig(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetConfigQueryResult = NonNullable<Awaited<ReturnType<typeof getConfig>>>
export type GetConfigQueryError = ErrorType<unknown>


export function useGetConfig<TData = Awaited<ReturnType<typeof getConfig>>, TError = ErrorType<unknown>>(
 params: undefined |  GetConfigParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getConfig>>,
          TError,
          Awaited<ReturnType<typeof getConfig>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetConfig<TData = Awaited<ReturnType<typeof getConfig>>, TError = ErrorType<unknown>>(
 params?: GetConfigParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getConfig>>,
          TError,
          Awaited<ReturnType<typeof getConfig>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetConfig<TData = Awaited<ReturnType<typeof getConfig>>, TError = ErrorType<unknown>>(
 params?: GetConfigParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetConfig<TData = Awaited<ReturnType<typeof getConfig>>, TError = ErrorType<unknown>>(
 params?: GetConfigParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetConfigQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetConfigQuery = async <TData = Awaited<ReturnType<typeof getConfig>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetConfigParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetConfigQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putConfigResponse200 = {
  data: Response
  status: 200
}
    
export type putConfigResponseSuccess = (putConfigResponse200) & {
  headers: Headers;
};
;

export type putConfigResponse = (putConfigResponseSuccess)

export const getPutConfigUrl = (params: PutConfigParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/config?${stringifiedParams}` : `/config`
}

export const putConfig = async (webConfig: WebConfig,
    params: PutConfigParams, options?: RequestInit): Promise<putConfigResponse> => {
  
  return useCustomClient<putConfigResponse>(getPutConfigUrl(params),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      webConfig,)
  }
);}




export const getPutConfigMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putConfig>>, TError,{data: BodyType<WebConfig>;params: PutConfigParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putConfig>>, TError,{data: BodyType<WebConfig>;params: PutConfigParams}, TContext> => {

const mutationKey = ['putConfig'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putConfig>>, {data: BodyType<WebConfig>;params: PutConfigParams}> = (props) => {
          const {data,params} = props ?? {};

          return  putConfig(data,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutConfigMutationResult = NonNullable<Awaited<ReturnType<typeof putConfig>>>
    export type PutConfigMutationBody = BodyType<WebConfig>
    export type PutConfigMutationError = ErrorType<unknown>

    export const usePutConfig = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putConfig>>, TError,{data: BodyType<WebConfig>;params: PutConfigParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putConfig>>,
        TError,
        {data: BodyType<WebConfig>;params: PutConfigParams},
        TContext
      > => {

      const mutationOptions = getPutConfigMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteConfigResponse200 = {
  data: Response
  status: 200
}
    
export type deleteConfigResponseSuccess = (deleteConfigResponse200) & {
  headers: Headers;
};
;

export type deleteConfigResponse = (deleteConfigResponseSuccess)

export const getDeleteConfigUrl = (params: DeleteConfigParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/config?${stringifiedParams}` : `/config`
}

export const deleteConfig = async (params: DeleteConfigParams, options?: RequestInit): Promise<deleteConfigResponse> => {
  
  return useCustomClient<deleteConfigResponse>(getDeleteConfigUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteConfigMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteConfig>>, TError,{params: DeleteConfigParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteConfig>>, TError,{params: DeleteConfigParams}, TContext> => {

const mutationKey = ['deleteConfig'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteConfig>>, {params: DeleteConfigParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteConfig(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteConfigMutationResult = NonNullable<Awaited<ReturnType<typeof deleteConfig>>>
    
    export type DeleteConfigMutationError = ErrorType<unknown>

    export const useDeleteConfig = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteConfig>>, TError,{params: DeleteConfigParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteConfig>>,
        TError,
        {params: DeleteConfigParams},
        TContext
      > => {

      const mutationOptions = getDeleteConfigMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    