/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  DeleteNotificationsParams,
  GetNotificationsParams,
  Notification,
  PutNotificationsMarkAsReadParams,
  PutNotificationsParams,
  Response
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Get
 */
export type getNotificationsResponse200 = {
  data: Response
  status: 200
}
    
export type getNotificationsResponseSuccess = (getNotificationsResponse200) & {
  headers: Headers;
};
;

export type getNotificationsResponse = (getNotificationsResponseSuccess)

export const getGetNotificationsUrl = (params?: GetNotificationsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/notifications?${stringifiedParams}` : `/notifications`
}

export const getNotifications = async (params?: GetNotificationsParams, options?: RequestInit): Promise<getNotificationsResponse> => {
  
  return useCustomClient<getNotificationsResponse>(getGetNotificationsUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetNotificationsInfiniteQueryKey = (params?: GetNotificationsParams,) => {
    return [
    'infinite', `/notifications`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetNotificationsQueryKey = (params?: GetNotificationsParams,) => {
    return [
    `/notifications`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetNotificationsInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getNotifications>>>, TError = ErrorType<unknown>>(params?: GetNotificationsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNotificationsInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNotifications>>> = ({ signal }) => getNotifications(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNotificationsInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getNotifications>>>
export type GetNotificationsInfiniteQueryError = ErrorType<unknown>


export function useGetNotificationsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNotifications>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetNotificationsParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNotifications>>,
          TError,
          Awaited<ReturnType<typeof getNotifications>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNotificationsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNotifications>>>, TError = ErrorType<unknown>>(
 params?: GetNotificationsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNotifications>>,
          TError,
          Awaited<ReturnType<typeof getNotifications>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNotificationsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNotifications>>>, TError = ErrorType<unknown>>(
 params?: GetNotificationsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNotificationsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNotifications>>>, TError = ErrorType<unknown>>(
 params?: GetNotificationsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNotificationsInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNotificationsInfiniteQuery = async <TData = Awaited<ReturnType<typeof getNotifications>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetNotificationsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNotificationsInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetNotificationsQueryOptions = <TData = Awaited<ReturnType<typeof getNotifications>>, TError = ErrorType<unknown>>(params?: GetNotificationsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNotificationsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNotifications>>> = ({ signal }) => getNotifications(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNotificationsQueryResult = NonNullable<Awaited<ReturnType<typeof getNotifications>>>
export type GetNotificationsQueryError = ErrorType<unknown>


export function useGetNotifications<TData = Awaited<ReturnType<typeof getNotifications>>, TError = ErrorType<unknown>>(
 params: undefined |  GetNotificationsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNotifications>>,
          TError,
          Awaited<ReturnType<typeof getNotifications>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNotifications<TData = Awaited<ReturnType<typeof getNotifications>>, TError = ErrorType<unknown>>(
 params?: GetNotificationsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNotifications>>,
          TError,
          Awaited<ReturnType<typeof getNotifications>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNotifications<TData = Awaited<ReturnType<typeof getNotifications>>, TError = ErrorType<unknown>>(
 params?: GetNotificationsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNotifications<TData = Awaited<ReturnType<typeof getNotifications>>, TError = ErrorType<unknown>>(
 params?: GetNotificationsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNotificationsQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNotificationsQuery = async <TData = Awaited<ReturnType<typeof getNotifications>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetNotificationsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNotifications>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNotificationsQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postNotificationsResponse200 = {
  data: Response
  status: 200
}
    
export type postNotificationsResponseSuccess = (postNotificationsResponse200) & {
  headers: Headers;
};
;

export type postNotificationsResponse = (postNotificationsResponseSuccess)

export const getPostNotificationsUrl = () => {


  

  return `/notifications`
}

export const postNotifications = async (notification: Notification[], options?: RequestInit): Promise<postNotificationsResponse> => {
  
  return useCustomClient<postNotificationsResponse>(getPostNotificationsUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      notification,)
  }
);}




export const getPostNotificationsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postNotifications>>, TError,{data: BodyType<Notification[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postNotifications>>, TError,{data: BodyType<Notification[]>}, TContext> => {

const mutationKey = ['postNotifications'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postNotifications>>, {data: BodyType<Notification[]>}> = (props) => {
          const {data} = props ?? {};

          return  postNotifications(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostNotificationsMutationResult = NonNullable<Awaited<ReturnType<typeof postNotifications>>>
    export type PostNotificationsMutationBody = BodyType<Notification[]>
    export type PostNotificationsMutationError = ErrorType<unknown>

    export const usePostNotifications = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postNotifications>>, TError,{data: BodyType<Notification[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postNotifications>>,
        TError,
        {data: BodyType<Notification[]>},
        TContext
      > => {

      const mutationOptions = getPostNotificationsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putNotificationsResponse200 = {
  data: Response
  status: 200
}
    
export type putNotificationsResponseSuccess = (putNotificationsResponse200) & {
  headers: Headers;
};
;

export type putNotificationsResponse = (putNotificationsResponseSuccess)

export const getPutNotificationsUrl = (params: PutNotificationsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/notifications?${stringifiedParams}` : `/notifications`
}

export const putNotifications = async (notification: Notification,
    params: PutNotificationsParams, options?: RequestInit): Promise<putNotificationsResponse> => {
  
  return useCustomClient<putNotificationsResponse>(getPutNotificationsUrl(params),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      notification,)
  }
);}




export const getPutNotificationsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putNotifications>>, TError,{data: BodyType<Notification>;params: PutNotificationsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putNotifications>>, TError,{data: BodyType<Notification>;params: PutNotificationsParams}, TContext> => {

const mutationKey = ['putNotifications'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putNotifications>>, {data: BodyType<Notification>;params: PutNotificationsParams}> = (props) => {
          const {data,params} = props ?? {};

          return  putNotifications(data,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutNotificationsMutationResult = NonNullable<Awaited<ReturnType<typeof putNotifications>>>
    export type PutNotificationsMutationBody = BodyType<Notification>
    export type PutNotificationsMutationError = ErrorType<unknown>

    export const usePutNotifications = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putNotifications>>, TError,{data: BodyType<Notification>;params: PutNotificationsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putNotifications>>,
        TError,
        {data: BodyType<Notification>;params: PutNotificationsParams},
        TContext
      > => {

      const mutationOptions = getPutNotificationsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteNotificationsResponse200 = {
  data: Response
  status: 200
}
    
export type deleteNotificationsResponseSuccess = (deleteNotificationsResponse200) & {
  headers: Headers;
};
;

export type deleteNotificationsResponse = (deleteNotificationsResponseSuccess)

export const getDeleteNotificationsUrl = (params: DeleteNotificationsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/notifications?${stringifiedParams}` : `/notifications`
}

export const deleteNotifications = async (params: DeleteNotificationsParams, options?: RequestInit): Promise<deleteNotificationsResponse> => {
  
  return useCustomClient<deleteNotificationsResponse>(getDeleteNotificationsUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteNotificationsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteNotifications>>, TError,{params: DeleteNotificationsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteNotifications>>, TError,{params: DeleteNotificationsParams}, TContext> => {

const mutationKey = ['deleteNotifications'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteNotifications>>, {params: DeleteNotificationsParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteNotifications(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteNotificationsMutationResult = NonNullable<Awaited<ReturnType<typeof deleteNotifications>>>
    
    export type DeleteNotificationsMutationError = ErrorType<unknown>

    export const useDeleteNotifications = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteNotifications>>, TError,{params: DeleteNotificationsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteNotifications>>,
        TError,
        {params: DeleteNotificationsParams},
        TContext
      > => {

      const mutationOptions = getDeleteNotificationsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putNotificationsMarkAsReadIdResponse200 = {
  data: Response
  status: 200
}
    
export type putNotificationsMarkAsReadIdResponseSuccess = (putNotificationsMarkAsReadIdResponse200) & {
  headers: Headers;
};
;

export type putNotificationsMarkAsReadIdResponse = (putNotificationsMarkAsReadIdResponseSuccess)

export const getPutNotificationsMarkAsReadIdUrl = (id: string,) => {


  

  return `/notifications/markAsRead/${id}`
}

export const putNotificationsMarkAsReadId = async (id: string, options?: RequestInit): Promise<putNotificationsMarkAsReadIdResponse> => {
  
  return useCustomClient<putNotificationsMarkAsReadIdResponse>(getPutNotificationsMarkAsReadIdUrl(id),
  {      
    ...options,
    method: 'PUT'
    
    
  }
);}




export const getPutNotificationsMarkAsReadIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putNotificationsMarkAsReadId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putNotificationsMarkAsReadId>>, TError,{id: string}, TContext> => {

const mutationKey = ['putNotificationsMarkAsReadId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putNotificationsMarkAsReadId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  putNotificationsMarkAsReadId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutNotificationsMarkAsReadIdMutationResult = NonNullable<Awaited<ReturnType<typeof putNotificationsMarkAsReadId>>>
    
    export type PutNotificationsMarkAsReadIdMutationError = ErrorType<unknown>

    export const usePutNotificationsMarkAsReadId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putNotificationsMarkAsReadId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putNotificationsMarkAsReadId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getPutNotificationsMarkAsReadIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putNotificationsMarkAsReadResponse200 = {
  data: Response
  status: 200
}
    
export type putNotificationsMarkAsReadResponseSuccess = (putNotificationsMarkAsReadResponse200) & {
  headers: Headers;
};
;

export type putNotificationsMarkAsReadResponse = (putNotificationsMarkAsReadResponseSuccess)

export const getPutNotificationsMarkAsReadUrl = (params: PutNotificationsMarkAsReadParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/notifications/markAsRead?${stringifiedParams}` : `/notifications/markAsRead`
}

export const putNotificationsMarkAsRead = async (params: PutNotificationsMarkAsReadParams, options?: RequestInit): Promise<putNotificationsMarkAsReadResponse> => {
  
  return useCustomClient<putNotificationsMarkAsReadResponse>(getPutNotificationsMarkAsReadUrl(params),
  {      
    ...options,
    method: 'PUT'
    
    
  }
);}




export const getPutNotificationsMarkAsReadMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putNotificationsMarkAsRead>>, TError,{params: PutNotificationsMarkAsReadParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putNotificationsMarkAsRead>>, TError,{params: PutNotificationsMarkAsReadParams}, TContext> => {

const mutationKey = ['putNotificationsMarkAsRead'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putNotificationsMarkAsRead>>, {params: PutNotificationsMarkAsReadParams}> = (props) => {
          const {params} = props ?? {};

          return  putNotificationsMarkAsRead(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutNotificationsMarkAsReadMutationResult = NonNullable<Awaited<ReturnType<typeof putNotificationsMarkAsRead>>>
    
    export type PutNotificationsMarkAsReadMutationError = ErrorType<unknown>

    export const usePutNotificationsMarkAsRead = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putNotificationsMarkAsRead>>, TError,{params: PutNotificationsMarkAsReadParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putNotificationsMarkAsRead>>,
        TError,
        {params: PutNotificationsMarkAsReadParams},
        TContext
      > => {

      const mutationOptions = getPutNotificationsMarkAsReadMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    