/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  GetNewsPageConfigGetHierarchicalParams,
  PutNewsPageConfigCategoryIdBody,
  Response
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Get page config category by id
 */
export type getNewsPageConfigCategoryIdResponse200 = {
  data: Response
  status: 200
}
    
export type getNewsPageConfigCategoryIdResponseSuccess = (getNewsPageConfigCategoryIdResponse200) & {
  headers: Headers;
};
;

export type getNewsPageConfigCategoryIdResponse = (getNewsPageConfigCategoryIdResponseSuccess)

export const getGetNewsPageConfigCategoryIdUrl = (id: string,) => {


  

  return `/newsPageConfig/category/${id}`
}

export const getNewsPageConfigCategoryId = async (id: string, options?: RequestInit): Promise<getNewsPageConfigCategoryIdResponse> => {
  
  return useCustomClient<getNewsPageConfigCategoryIdResponse>(getGetNewsPageConfigCategoryIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetNewsPageConfigCategoryIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/newsPageConfig/category/${id}`
    ] as const;
    }

export const getGetNewsPageConfigCategoryIdQueryKey = (id?: string,) => {
    return [
    `/newsPageConfig/category/${id}`
    ] as const;
    }

    
export const getGetNewsPageConfigCategoryIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsPageConfigCategoryIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>> = ({ signal }) => getNewsPageConfigCategoryId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsPageConfigCategoryIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>>
export type GetNewsPageConfigCategoryIdInfiniteQueryError = ErrorType<unknown>


export function useGetNewsPageConfigCategoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigCategoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigCategoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsPageConfigCategoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsPageConfigCategoryIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsPageConfigCategoryIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsPageConfigCategoryIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetNewsPageConfigCategoryIdQueryOptions = <TData = Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsPageConfigCategoryIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>> = ({ signal }) => getNewsPageConfigCategoryId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsPageConfigCategoryIdQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>>
export type GetNewsPageConfigCategoryIdQueryError = ErrorType<unknown>


export function useGetNewsPageConfigCategoryId<TData = Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigCategoryId<TData = Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigCategoryId<TData = Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsPageConfigCategoryId<TData = Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsPageConfigCategoryIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsPageConfigCategoryIdQuery = async <TData = Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsPageConfigCategoryIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Update page config category
 */
export type putNewsPageConfigCategoryIdResponse200 = {
  data: Response
  status: 200
}
    
export type putNewsPageConfigCategoryIdResponseSuccess = (putNewsPageConfigCategoryIdResponse200) & {
  headers: Headers;
};
;

export type putNewsPageConfigCategoryIdResponse = (putNewsPageConfigCategoryIdResponseSuccess)

export const getPutNewsPageConfigCategoryIdUrl = (id: string,) => {


  

  return `/newsPageConfig/category/${id}`
}

export const putNewsPageConfigCategoryId = async (id: string,
    putNewsPageConfigCategoryIdBody: PutNewsPageConfigCategoryIdBody, options?: RequestInit): Promise<putNewsPageConfigCategoryIdResponse> => {
  
  return useCustomClient<putNewsPageConfigCategoryIdResponse>(getPutNewsPageConfigCategoryIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      putNewsPageConfigCategoryIdBody,)
  }
);}




export const getPutNewsPageConfigCategoryIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putNewsPageConfigCategoryId>>, TError,{id: string;data: BodyType<PutNewsPageConfigCategoryIdBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putNewsPageConfigCategoryId>>, TError,{id: string;data: BodyType<PutNewsPageConfigCategoryIdBody>}, TContext> => {

const mutationKey = ['putNewsPageConfigCategoryId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putNewsPageConfigCategoryId>>, {id: string;data: BodyType<PutNewsPageConfigCategoryIdBody>}> = (props) => {
          const {id,data} = props ?? {};

          return  putNewsPageConfigCategoryId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutNewsPageConfigCategoryIdMutationResult = NonNullable<Awaited<ReturnType<typeof putNewsPageConfigCategoryId>>>
    export type PutNewsPageConfigCategoryIdMutationBody = BodyType<PutNewsPageConfigCategoryIdBody>
    export type PutNewsPageConfigCategoryIdMutationError = ErrorType<unknown>

    export const usePutNewsPageConfigCategoryId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putNewsPageConfigCategoryId>>, TError,{id: string;data: BodyType<PutNewsPageConfigCategoryIdBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putNewsPageConfigCategoryId>>,
        TError,
        {id: string;data: BodyType<PutNewsPageConfigCategoryIdBody>},
        TContext
      > => {

      const mutationOptions = getPutNewsPageConfigCategoryIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get page config category
 */
export type getNewsPageConfigCategoryResponse200 = {
  data: Response
  status: 200
}
    
export type getNewsPageConfigCategoryResponseSuccess = (getNewsPageConfigCategoryResponse200) & {
  headers: Headers;
};
;

export type getNewsPageConfigCategoryResponse = (getNewsPageConfigCategoryResponseSuccess)

export const getGetNewsPageConfigCategoryUrl = () => {


  

  return `/newsPageConfig/category`
}

export const getNewsPageConfigCategory = async ( options?: RequestInit): Promise<getNewsPageConfigCategoryResponse> => {
  
  return useCustomClient<getNewsPageConfigCategoryResponse>(getGetNewsPageConfigCategoryUrl(),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetNewsPageConfigCategoryInfiniteQueryKey = () => {
    return [
    'infinite', `/newsPageConfig/category`
    ] as const;
    }

export const getGetNewsPageConfigCategoryQueryKey = () => {
    return [
    `/newsPageConfig/category`
    ] as const;
    }

    
export const getGetNewsPageConfigCategoryInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigCategory>>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsPageConfigCategoryInfiniteQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsPageConfigCategory>>> = ({ signal }) => getNewsPageConfigCategory({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsPageConfigCategoryInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsPageConfigCategory>>>
export type GetNewsPageConfigCategoryInfiniteQueryError = ErrorType<unknown>


export function useGetNewsPageConfigCategoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigCategory>>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigCategory>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigCategory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigCategoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigCategory>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigCategory>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigCategory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigCategoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigCategory>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsPageConfigCategoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigCategory>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsPageConfigCategoryInfiniteQueryOptions(options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsPageConfigCategoryInfiniteQuery = async <TData = Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsPageConfigCategoryInfiniteQueryOptions(options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetNewsPageConfigCategoryQueryOptions = <TData = Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsPageConfigCategoryQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsPageConfigCategory>>> = ({ signal }) => getNewsPageConfigCategory({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsPageConfigCategoryQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsPageConfigCategory>>>
export type GetNewsPageConfigCategoryQueryError = ErrorType<unknown>


export function useGetNewsPageConfigCategory<TData = Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigCategory>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigCategory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigCategory<TData = Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigCategory>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigCategory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigCategory<TData = Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsPageConfigCategory<TData = Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsPageConfigCategoryQueryOptions(options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsPageConfigCategoryQuery = async <TData = Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsPageConfigCategoryQueryOptions(options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getNewsPageConfigGetAllLinksResponse200 = {
  data: Response
  status: 200
}
    
export type getNewsPageConfigGetAllLinksResponseSuccess = (getNewsPageConfigGetAllLinksResponse200) & {
  headers: Headers;
};
;

export type getNewsPageConfigGetAllLinksResponse = (getNewsPageConfigGetAllLinksResponseSuccess)

export const getGetNewsPageConfigGetAllLinksUrl = () => {


  

  return `/newsPageConfig/getAllLinks`
}

export const getNewsPageConfigGetAllLinks = async ( options?: RequestInit): Promise<getNewsPageConfigGetAllLinksResponse> => {
  
  return useCustomClient<getNewsPageConfigGetAllLinksResponse>(getGetNewsPageConfigGetAllLinksUrl(),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetNewsPageConfigGetAllLinksInfiniteQueryKey = () => {
    return [
    'infinite', `/newsPageConfig/getAllLinks`
    ] as const;
    }

export const getGetNewsPageConfigGetAllLinksQueryKey = () => {
    return [
    `/newsPageConfig/getAllLinks`
    ] as const;
    }

    
export const getGetNewsPageConfigGetAllLinksInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsPageConfigGetAllLinksInfiniteQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>> = ({ signal }) => getNewsPageConfigGetAllLinks({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsPageConfigGetAllLinksInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>>
export type GetNewsPageConfigGetAllLinksInfiniteQueryError = ErrorType<unknown>


export function useGetNewsPageConfigGetAllLinksInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigGetAllLinksInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigGetAllLinksInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsPageConfigGetAllLinksInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsPageConfigGetAllLinksInfiniteQueryOptions(options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsPageConfigGetAllLinksInfiniteQuery = async <TData = Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsPageConfigGetAllLinksInfiniteQueryOptions(options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetNewsPageConfigGetAllLinksQueryOptions = <TData = Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsPageConfigGetAllLinksQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>> = ({ signal }) => getNewsPageConfigGetAllLinks({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsPageConfigGetAllLinksQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>>
export type GetNewsPageConfigGetAllLinksQueryError = ErrorType<unknown>


export function useGetNewsPageConfigGetAllLinks<TData = Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigGetAllLinks<TData = Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigGetAllLinks<TData = Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsPageConfigGetAllLinks<TData = Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsPageConfigGetAllLinksQueryOptions(options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsPageConfigGetAllLinksQuery = async <TData = Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetAllLinks>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsPageConfigGetAllLinksQueryOptions(options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get hierarchical page config
 */
export type getNewsPageConfigGetHierarchicalResponse200 = {
  data: Response
  status: 200
}
    
export type getNewsPageConfigGetHierarchicalResponseSuccess = (getNewsPageConfigGetHierarchicalResponse200) & {
  headers: Headers;
};
;

export type getNewsPageConfigGetHierarchicalResponse = (getNewsPageConfigGetHierarchicalResponseSuccess)

export const getGetNewsPageConfigGetHierarchicalUrl = (params?: GetNewsPageConfigGetHierarchicalParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/NewsPageConfig/getHierarchical?${stringifiedParams}` : `/NewsPageConfig/getHierarchical`
}

export const getNewsPageConfigGetHierarchical = async (params?: GetNewsPageConfigGetHierarchicalParams, options?: RequestInit): Promise<getNewsPageConfigGetHierarchicalResponse> => {
  
  return useCustomClient<getNewsPageConfigGetHierarchicalResponse>(getGetNewsPageConfigGetHierarchicalUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetNewsPageConfigGetHierarchicalInfiniteQueryKey = (params?: GetNewsPageConfigGetHierarchicalParams,) => {
    return [
    'infinite', `/NewsPageConfig/getHierarchical`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetNewsPageConfigGetHierarchicalQueryKey = (params?: GetNewsPageConfigGetHierarchicalParams,) => {
    return [
    `/NewsPageConfig/getHierarchical`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetNewsPageConfigGetHierarchicalInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>>, TError = ErrorType<unknown>>(params?: GetNewsPageConfigGetHierarchicalParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsPageConfigGetHierarchicalInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>> = ({ signal }) => getNewsPageConfigGetHierarchical(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsPageConfigGetHierarchicalInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>>
export type GetNewsPageConfigGetHierarchicalInfiniteQueryError = ErrorType<unknown>


export function useGetNewsPageConfigGetHierarchicalInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetNewsPageConfigGetHierarchicalParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigGetHierarchicalInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>>, TError = ErrorType<unknown>>(
 params?: GetNewsPageConfigGetHierarchicalParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigGetHierarchicalInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>>, TError = ErrorType<unknown>>(
 params?: GetNewsPageConfigGetHierarchicalParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsPageConfigGetHierarchicalInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>>, TError = ErrorType<unknown>>(
 params?: GetNewsPageConfigGetHierarchicalParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsPageConfigGetHierarchicalInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsPageConfigGetHierarchicalInfiniteQuery = async <TData = Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetNewsPageConfigGetHierarchicalParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsPageConfigGetHierarchicalInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetNewsPageConfigGetHierarchicalQueryOptions = <TData = Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError = ErrorType<unknown>>(params?: GetNewsPageConfigGetHierarchicalParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsPageConfigGetHierarchicalQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>> = ({ signal }) => getNewsPageConfigGetHierarchical(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsPageConfigGetHierarchicalQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>>
export type GetNewsPageConfigGetHierarchicalQueryError = ErrorType<unknown>


export function useGetNewsPageConfigGetHierarchical<TData = Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError = ErrorType<unknown>>(
 params: undefined |  GetNewsPageConfigGetHierarchicalParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigGetHierarchical<TData = Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError = ErrorType<unknown>>(
 params?: GetNewsPageConfigGetHierarchicalParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigGetHierarchical<TData = Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError = ErrorType<unknown>>(
 params?: GetNewsPageConfigGetHierarchicalParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsPageConfigGetHierarchical<TData = Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError = ErrorType<unknown>>(
 params?: GetNewsPageConfigGetHierarchicalParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsPageConfigGetHierarchicalQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsPageConfigGetHierarchicalQuery = async <TData = Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetNewsPageConfigGetHierarchicalParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfigGetHierarchical>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsPageConfigGetHierarchicalQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getNewsPageConfigResponse200 = {
  data: Response
  status: 200
}
    
export type getNewsPageConfigResponseSuccess = (getNewsPageConfigResponse200) & {
  headers: Headers;
};
;

export type getNewsPageConfigResponse = (getNewsPageConfigResponseSuccess)

export const getGetNewsPageConfigUrl = () => {


  

  return `/newsPageConfig`
}

export const getNewsPageConfig = async ( options?: RequestInit): Promise<getNewsPageConfigResponse> => {
  
  return useCustomClient<getNewsPageConfigResponse>(getGetNewsPageConfigUrl(),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetNewsPageConfigInfiniteQueryKey = () => {
    return [
    'infinite', `/newsPageConfig`
    ] as const;
    }

export const getGetNewsPageConfigQueryKey = () => {
    return [
    `/newsPageConfig`
    ] as const;
    }

    
export const getGetNewsPageConfigInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfig>>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsPageConfigInfiniteQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsPageConfig>>> = ({ signal }) => getNewsPageConfig({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsPageConfigInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsPageConfig>>>
export type GetNewsPageConfigInfiniteQueryError = ErrorType<unknown>


export function useGetNewsPageConfigInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfig>>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfig>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfig>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfig>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfig>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfig>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfigInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfig>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsPageConfigInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getNewsPageConfig>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsPageConfigInfiniteQueryOptions(options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsPageConfigInfiniteQuery = async <TData = Awaited<ReturnType<typeof getNewsPageConfig>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsPageConfigInfiniteQueryOptions(options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetNewsPageConfigQueryOptions = <TData = Awaited<ReturnType<typeof getNewsPageConfig>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetNewsPageConfigQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getNewsPageConfig>>> = ({ signal }) => getNewsPageConfig({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetNewsPageConfigQueryResult = NonNullable<Awaited<ReturnType<typeof getNewsPageConfig>>>
export type GetNewsPageConfigQueryError = ErrorType<unknown>


export function useGetNewsPageConfig<TData = Awaited<ReturnType<typeof getNewsPageConfig>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfig>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfig>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfig<TData = Awaited<ReturnType<typeof getNewsPageConfig>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getNewsPageConfig>>,
          TError,
          Awaited<ReturnType<typeof getNewsPageConfig>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetNewsPageConfig<TData = Awaited<ReturnType<typeof getNewsPageConfig>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetNewsPageConfig<TData = Awaited<ReturnType<typeof getNewsPageConfig>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetNewsPageConfigQueryOptions(options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetNewsPageConfigQuery = async <TData = Awaited<ReturnType<typeof getNewsPageConfig>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getNewsPageConfig>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetNewsPageConfigQueryOptions(options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



