/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  DeleteOrderParams,
  DeleteOrderPaymentParams,
  ExtPortalPayment,
  GetOrderGetMyOrdersParams,
  GetOrderParams,
  GetOrderPaymentParams,
  Order,
  OrderPayment,
  OrderPaymentBody,
  PutOrderPaymentParams,
  Response
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Get
 */
export type getOrderIdResponse200 = {
  data: Response
  status: 200
}
    
export type getOrderIdResponseSuccess = (getOrderIdResponse200) & {
  headers: Headers;
};
;

export type getOrderIdResponse = (getOrderIdResponseSuccess)

export const getGetOrderIdUrl = (id: string,) => {


  

  return `/order/${id}`
}

export const getOrderId = async (id: string, options?: RequestInit): Promise<getOrderIdResponse> => {
  
  return useCustomClient<getOrderIdResponse>(getGetOrderIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrderIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/order/${id}`
    ] as const;
    }

export const getGetOrderIdQueryKey = (id?: string,) => {
    return [
    `/order/${id}`
    ] as const;
    }

    
export const getGetOrderIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrderId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrderIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrderId>>> = ({ signal }) => getOrderId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrderIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrderId>>>
export type GetOrderIdInfiniteQueryError = ErrorType<unknown>


export function useGetOrderIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderId>>,
          TError,
          Awaited<ReturnType<typeof getOrderId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderId>>,
          TError,
          Awaited<ReturnType<typeof getOrderId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrderIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrderIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrderIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrderId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrderIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrderIdQueryOptions = <TData = Awaited<ReturnType<typeof getOrderId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrderIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrderId>>> = ({ signal }) => getOrderId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrderIdQueryResult = NonNullable<Awaited<ReturnType<typeof getOrderId>>>
export type GetOrderIdQueryError = ErrorType<unknown>


export function useGetOrderId<TData = Awaited<ReturnType<typeof getOrderId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderId>>,
          TError,
          Awaited<ReturnType<typeof getOrderId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderId<TData = Awaited<ReturnType<typeof getOrderId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderId>>,
          TError,
          Awaited<ReturnType<typeof getOrderId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderId<TData = Awaited<ReturnType<typeof getOrderId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrderId<TData = Awaited<ReturnType<typeof getOrderId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrderIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrderIdQuery = async <TData = Awaited<ReturnType<typeof getOrderId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrderIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putOrderIdResponse200 = {
  data: Response
  status: 200
}
    
export type putOrderIdResponseSuccess = (putOrderIdResponse200) & {
  headers: Headers;
};
;

export type putOrderIdResponse = (putOrderIdResponseSuccess)

export const getPutOrderIdUrl = (id: string,) => {


  

  return `/order/${id}`
}

export const putOrderId = async (id: string,
    order: Order, options?: RequestInit): Promise<putOrderIdResponse> => {
  
  return useCustomClient<putOrderIdResponse>(getPutOrderIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      order,)
  }
);}




export const getPutOrderIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrderId>>, TError,{id: string;data: BodyType<Order>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putOrderId>>, TError,{id: string;data: BodyType<Order>}, TContext> => {

const mutationKey = ['putOrderId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putOrderId>>, {id: string;data: BodyType<Order>}> = (props) => {
          const {id,data} = props ?? {};

          return  putOrderId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutOrderIdMutationResult = NonNullable<Awaited<ReturnType<typeof putOrderId>>>
    export type PutOrderIdMutationBody = BodyType<Order>
    export type PutOrderIdMutationError = ErrorType<unknown>

    export const usePutOrderId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrderId>>, TError,{id: string;data: BodyType<Order>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putOrderId>>,
        TError,
        {id: string;data: BodyType<Order>},
        TContext
      > => {

      const mutationOptions = getPutOrderIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteOrderIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteOrderIdResponseSuccess = (deleteOrderIdResponse200) & {
  headers: Headers;
};
;

export type deleteOrderIdResponse = (deleteOrderIdResponseSuccess)

export const getDeleteOrderIdUrl = (id: string,) => {


  

  return `/order/${id}`
}

export const deleteOrderId = async (id: string, options?: RequestInit): Promise<deleteOrderIdResponse> => {
  
  return useCustomClient<deleteOrderIdResponse>(getDeleteOrderIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteOrderIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrderId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteOrderId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteOrderId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteOrderId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteOrderId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteOrderIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteOrderId>>>
    
    export type DeleteOrderIdMutationError = ErrorType<unknown>

    export const useDeleteOrderId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrderId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteOrderId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteOrderIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrderGetMyOrdersResponse200 = {
  data: Response
  status: 200
}
    
export type getOrderGetMyOrdersResponseSuccess = (getOrderGetMyOrdersResponse200) & {
  headers: Headers;
};
;

export type getOrderGetMyOrdersResponse = (getOrderGetMyOrdersResponseSuccess)

export const getGetOrderGetMyOrdersUrl = (params?: GetOrderGetMyOrdersParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/order/getMyOrders?${stringifiedParams}` : `/order/getMyOrders`
}

export const getOrderGetMyOrders = async (params?: GetOrderGetMyOrdersParams, options?: RequestInit): Promise<getOrderGetMyOrdersResponse> => {
  
  return useCustomClient<getOrderGetMyOrdersResponse>(getGetOrderGetMyOrdersUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrderGetMyOrdersInfiniteQueryKey = (params?: GetOrderGetMyOrdersParams,) => {
    return [
    'infinite', `/order/getMyOrders`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrderGetMyOrdersQueryKey = (params?: GetOrderGetMyOrdersParams,) => {
    return [
    `/order/getMyOrders`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrderGetMyOrdersInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrderGetMyOrders>>>, TError = ErrorType<unknown>>(params?: GetOrderGetMyOrdersParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrderGetMyOrdersInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrderGetMyOrders>>> = ({ signal }) => getOrderGetMyOrders(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrderGetMyOrdersInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrderGetMyOrders>>>
export type GetOrderGetMyOrdersInfiniteQueryError = ErrorType<unknown>


export function useGetOrderGetMyOrdersInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderGetMyOrders>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrderGetMyOrdersParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderGetMyOrders>>,
          TError,
          Awaited<ReturnType<typeof getOrderGetMyOrders>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderGetMyOrdersInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderGetMyOrders>>>, TError = ErrorType<unknown>>(
 params?: GetOrderGetMyOrdersParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderGetMyOrders>>,
          TError,
          Awaited<ReturnType<typeof getOrderGetMyOrders>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderGetMyOrdersInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderGetMyOrders>>>, TError = ErrorType<unknown>>(
 params?: GetOrderGetMyOrdersParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrderGetMyOrdersInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderGetMyOrders>>>, TError = ErrorType<unknown>>(
 params?: GetOrderGetMyOrdersParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrderGetMyOrdersInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrderGetMyOrdersInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrderGetMyOrdersParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrderGetMyOrdersInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrderGetMyOrdersQueryOptions = <TData = Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError = ErrorType<unknown>>(params?: GetOrderGetMyOrdersParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrderGetMyOrdersQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrderGetMyOrders>>> = ({ signal }) => getOrderGetMyOrders(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrderGetMyOrdersQueryResult = NonNullable<Awaited<ReturnType<typeof getOrderGetMyOrders>>>
export type GetOrderGetMyOrdersQueryError = ErrorType<unknown>


export function useGetOrderGetMyOrders<TData = Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrderGetMyOrdersParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderGetMyOrders>>,
          TError,
          Awaited<ReturnType<typeof getOrderGetMyOrders>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderGetMyOrders<TData = Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError = ErrorType<unknown>>(
 params?: GetOrderGetMyOrdersParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderGetMyOrders>>,
          TError,
          Awaited<ReturnType<typeof getOrderGetMyOrders>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderGetMyOrders<TData = Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError = ErrorType<unknown>>(
 params?: GetOrderGetMyOrdersParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrderGetMyOrders<TData = Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError = ErrorType<unknown>>(
 params?: GetOrderGetMyOrdersParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrderGetMyOrdersQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrderGetMyOrdersQuery = async <TData = Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrderGetMyOrdersParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderGetMyOrders>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrderGetMyOrdersQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getOrderResponse200 = {
  data: Response
  status: 200
}
    
export type getOrderResponseSuccess = (getOrderResponse200) & {
  headers: Headers;
};
;

export type getOrderResponse = (getOrderResponseSuccess)

export const getGetOrderUrl = (params?: GetOrderParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/order?${stringifiedParams}` : `/order`
}

export const getOrder = async (params?: GetOrderParams, options?: RequestInit): Promise<getOrderResponse> => {
  
  return useCustomClient<getOrderResponse>(getGetOrderUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrderInfiniteQueryKey = (params?: GetOrderParams,) => {
    return [
    'infinite', `/order`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrderQueryKey = (params?: GetOrderParams,) => {
    return [
    `/order`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrderInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrder>>>, TError = ErrorType<unknown>>(params?: GetOrderParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrderInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrder>>> = ({ signal }) => getOrder(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrderInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrder>>>
export type GetOrderInfiniteQueryError = ErrorType<unknown>


export function useGetOrderInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrder>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrderParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrder>>,
          TError,
          Awaited<ReturnType<typeof getOrder>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrder>>>, TError = ErrorType<unknown>>(
 params?: GetOrderParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrder>>,
          TError,
          Awaited<ReturnType<typeof getOrder>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrder>>>, TError = ErrorType<unknown>>(
 params?: GetOrderParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrderInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrder>>>, TError = ErrorType<unknown>>(
 params?: GetOrderParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrderInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrderInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrder>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrderParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrderInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrderQueryOptions = <TData = Awaited<ReturnType<typeof getOrder>>, TError = ErrorType<unknown>>(params?: GetOrderParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrderQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrder>>> = ({ signal }) => getOrder(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrderQueryResult = NonNullable<Awaited<ReturnType<typeof getOrder>>>
export type GetOrderQueryError = ErrorType<unknown>


export function useGetOrder<TData = Awaited<ReturnType<typeof getOrder>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrderParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrder>>,
          TError,
          Awaited<ReturnType<typeof getOrder>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrder<TData = Awaited<ReturnType<typeof getOrder>>, TError = ErrorType<unknown>>(
 params?: GetOrderParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrder>>,
          TError,
          Awaited<ReturnType<typeof getOrder>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrder<TData = Awaited<ReturnType<typeof getOrder>>, TError = ErrorType<unknown>>(
 params?: GetOrderParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrder<TData = Awaited<ReturnType<typeof getOrder>>, TError = ErrorType<unknown>>(
 params?: GetOrderParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrderQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrderQuery = async <TData = Awaited<ReturnType<typeof getOrder>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrderParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrder>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrderQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postOrderResponse200 = {
  data: Response
  status: 200
}
    
export type postOrderResponseSuccess = (postOrderResponse200) & {
  headers: Headers;
};
;

export type postOrderResponse = (postOrderResponseSuccess)

export const getPostOrderUrl = () => {


  

  return `/order`
}

export const postOrder = async (order: Order[], options?: RequestInit): Promise<postOrderResponse> => {
  
  return useCustomClient<postOrderResponse>(getPostOrderUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      order,)
  }
);}




export const getPostOrderMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrder>>, TError,{data: BodyType<Order[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrder>>, TError,{data: BodyType<Order[]>}, TContext> => {

const mutationKey = ['postOrder'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrder>>, {data: BodyType<Order[]>}> = (props) => {
          const {data} = props ?? {};

          return  postOrder(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrderMutationResult = NonNullable<Awaited<ReturnType<typeof postOrder>>>
    export type PostOrderMutationBody = BodyType<Order[]>
    export type PostOrderMutationError = ErrorType<unknown>

    export const usePostOrder = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrder>>, TError,{data: BodyType<Order[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrder>>,
        TError,
        {data: BodyType<Order[]>},
        TContext
      > => {

      const mutationOptions = getPostOrderMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteOrderResponse200 = {
  data: Response
  status: 200
}
    
export type deleteOrderResponseSuccess = (deleteOrderResponse200) & {
  headers: Headers;
};
;

export type deleteOrderResponse = (deleteOrderResponseSuccess)

export const getDeleteOrderUrl = (params: DeleteOrderParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/order?${stringifiedParams}` : `/order`
}

export const deleteOrder = async (params: DeleteOrderParams, options?: RequestInit): Promise<deleteOrderResponse> => {
  
  return useCustomClient<deleteOrderResponse>(getDeleteOrderUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteOrderMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrder>>, TError,{params: DeleteOrderParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteOrder>>, TError,{params: DeleteOrderParams}, TContext> => {

const mutationKey = ['deleteOrder'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteOrder>>, {params: DeleteOrderParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteOrder(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteOrderMutationResult = NonNullable<Awaited<ReturnType<typeof deleteOrder>>>
    
    export type DeleteOrderMutationError = ErrorType<unknown>

    export const useDeleteOrder = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrder>>, TError,{params: DeleteOrderParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteOrder>>,
        TError,
        {params: DeleteOrderParams},
        TContext
      > => {

      const mutationOptions = getDeleteOrderMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrderPaymentIdResponse200 = {
  data: Response
  status: 200
}
    
export type getOrderPaymentIdResponseSuccess = (getOrderPaymentIdResponse200) & {
  headers: Headers;
};
;

export type getOrderPaymentIdResponse = (getOrderPaymentIdResponseSuccess)

export const getGetOrderPaymentIdUrl = (id: string,) => {


  

  return `/order/payment/${id}`
}

export const getOrderPaymentId = async (id: string, options?: RequestInit): Promise<getOrderPaymentIdResponse> => {
  
  return useCustomClient<getOrderPaymentIdResponse>(getGetOrderPaymentIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrderPaymentIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/order/payment/${id}`
    ] as const;
    }

export const getGetOrderPaymentIdQueryKey = (id?: string,) => {
    return [
    `/order/payment/${id}`
    ] as const;
    }

    
export const getGetOrderPaymentIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrderPaymentId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrderPaymentIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrderPaymentId>>> = ({ signal }) => getOrderPaymentId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrderPaymentIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrderPaymentId>>>
export type GetOrderPaymentIdInfiniteQueryError = ErrorType<unknown>


export function useGetOrderPaymentIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderPaymentId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderPaymentId>>,
          TError,
          Awaited<ReturnType<typeof getOrderPaymentId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderPaymentIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderPaymentId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderPaymentId>>,
          TError,
          Awaited<ReturnType<typeof getOrderPaymentId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderPaymentIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderPaymentId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrderPaymentIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderPaymentId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrderPaymentIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrderPaymentIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrderPaymentId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrderPaymentIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrderPaymentIdQueryOptions = <TData = Awaited<ReturnType<typeof getOrderPaymentId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrderPaymentIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrderPaymentId>>> = ({ signal }) => getOrderPaymentId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrderPaymentIdQueryResult = NonNullable<Awaited<ReturnType<typeof getOrderPaymentId>>>
export type GetOrderPaymentIdQueryError = ErrorType<unknown>


export function useGetOrderPaymentId<TData = Awaited<ReturnType<typeof getOrderPaymentId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderPaymentId>>,
          TError,
          Awaited<ReturnType<typeof getOrderPaymentId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderPaymentId<TData = Awaited<ReturnType<typeof getOrderPaymentId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderPaymentId>>,
          TError,
          Awaited<ReturnType<typeof getOrderPaymentId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderPaymentId<TData = Awaited<ReturnType<typeof getOrderPaymentId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrderPaymentId<TData = Awaited<ReturnType<typeof getOrderPaymentId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrderPaymentIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrderPaymentIdQuery = async <TData = Awaited<ReturnType<typeof getOrderPaymentId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderPaymentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrderPaymentIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putOrderPaymentIdResponse200 = {
  data: Response
  status: 200
}
    
export type putOrderPaymentIdResponseSuccess = (putOrderPaymentIdResponse200) & {
  headers: Headers;
};
;

export type putOrderPaymentIdResponse = (putOrderPaymentIdResponseSuccess)

export const getPutOrderPaymentIdUrl = (id: string,) => {


  

  return `/order/payment/${id}`
}

export const putOrderPaymentId = async (id: string,
    orderPaymentBody: OrderPaymentBody, options?: RequestInit): Promise<putOrderPaymentIdResponse> => {
  
  return useCustomClient<putOrderPaymentIdResponse>(getPutOrderPaymentIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      orderPaymentBody,)
  }
);}




export const getPutOrderPaymentIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrderPaymentId>>, TError,{id: string;data: BodyType<OrderPaymentBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putOrderPaymentId>>, TError,{id: string;data: BodyType<OrderPaymentBody>}, TContext> => {

const mutationKey = ['putOrderPaymentId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putOrderPaymentId>>, {id: string;data: BodyType<OrderPaymentBody>}> = (props) => {
          const {id,data} = props ?? {};

          return  putOrderPaymentId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutOrderPaymentIdMutationResult = NonNullable<Awaited<ReturnType<typeof putOrderPaymentId>>>
    export type PutOrderPaymentIdMutationBody = BodyType<OrderPaymentBody>
    export type PutOrderPaymentIdMutationError = ErrorType<unknown>

    export const usePutOrderPaymentId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrderPaymentId>>, TError,{id: string;data: BodyType<OrderPaymentBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putOrderPaymentId>>,
        TError,
        {id: string;data: BodyType<OrderPaymentBody>},
        TContext
      > => {

      const mutationOptions = getPutOrderPaymentIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteOrderPaymentIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteOrderPaymentIdResponseSuccess = (deleteOrderPaymentIdResponse200) & {
  headers: Headers;
};
;

export type deleteOrderPaymentIdResponse = (deleteOrderPaymentIdResponseSuccess)

export const getDeleteOrderPaymentIdUrl = (id: string,) => {


  

  return `/order/payment/${id}`
}

export const deleteOrderPaymentId = async (id: string, options?: RequestInit): Promise<deleteOrderPaymentIdResponse> => {
  
  return useCustomClient<deleteOrderPaymentIdResponse>(getDeleteOrderPaymentIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteOrderPaymentIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrderPaymentId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteOrderPaymentId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteOrderPaymentId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteOrderPaymentId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteOrderPaymentId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteOrderPaymentIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteOrderPaymentId>>>
    
    export type DeleteOrderPaymentIdMutationError = ErrorType<unknown>

    export const useDeleteOrderPaymentId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrderPaymentId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteOrderPaymentId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteOrderPaymentIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Post payment
 */
export type postOrderPaymentPortalGeneratePaymentLinkResponse200 = {
  data: Response
  status: 200
}
    
export type postOrderPaymentPortalGeneratePaymentLinkResponseSuccess = (postOrderPaymentPortalGeneratePaymentLinkResponse200) & {
  headers: Headers;
};
;

export type postOrderPaymentPortalGeneratePaymentLinkResponse = (postOrderPaymentPortalGeneratePaymentLinkResponseSuccess)

export const getPostOrderPaymentPortalGeneratePaymentLinkUrl = (portal: string,) => {


  

  return `/order/payment/${portal}/generatePaymentLink`
}

export const postOrderPaymentPortalGeneratePaymentLink = async (portal: string,
    extPortalPayment: ExtPortalPayment, options?: RequestInit): Promise<postOrderPaymentPortalGeneratePaymentLinkResponse> => {
  
  return useCustomClient<postOrderPaymentPortalGeneratePaymentLinkResponse>(getPostOrderPaymentPortalGeneratePaymentLinkUrl(portal),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      extPortalPayment,)
  }
);}




export const getPostOrderPaymentPortalGeneratePaymentLinkMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrderPaymentPortalGeneratePaymentLink>>, TError,{portal: string;data: BodyType<ExtPortalPayment>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrderPaymentPortalGeneratePaymentLink>>, TError,{portal: string;data: BodyType<ExtPortalPayment>}, TContext> => {

const mutationKey = ['postOrderPaymentPortalGeneratePaymentLink'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrderPaymentPortalGeneratePaymentLink>>, {portal: string;data: BodyType<ExtPortalPayment>}> = (props) => {
          const {portal,data} = props ?? {};

          return  postOrderPaymentPortalGeneratePaymentLink(portal,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrderPaymentPortalGeneratePaymentLinkMutationResult = NonNullable<Awaited<ReturnType<typeof postOrderPaymentPortalGeneratePaymentLink>>>
    export type PostOrderPaymentPortalGeneratePaymentLinkMutationBody = BodyType<ExtPortalPayment>
    export type PostOrderPaymentPortalGeneratePaymentLinkMutationError = ErrorType<unknown>

    export const usePostOrderPaymentPortalGeneratePaymentLink = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrderPaymentPortalGeneratePaymentLink>>, TError,{portal: string;data: BodyType<ExtPortalPayment>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrderPaymentPortalGeneratePaymentLink>>,
        TError,
        {portal: string;data: BodyType<ExtPortalPayment>},
        TContext
      > => {

      const mutationOptions = getPostOrderPaymentPortalGeneratePaymentLinkMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrderPaymentResponse200 = {
  data: Response
  status: 200
}
    
export type getOrderPaymentResponseSuccess = (getOrderPaymentResponse200) & {
  headers: Headers;
};
;

export type getOrderPaymentResponse = (getOrderPaymentResponseSuccess)

export const getGetOrderPaymentUrl = (params?: GetOrderPaymentParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/order/payment?${stringifiedParams}` : `/order/payment`
}

export const getOrderPayment = async (params?: GetOrderPaymentParams, options?: RequestInit): Promise<getOrderPaymentResponse> => {
  
  return useCustomClient<getOrderPaymentResponse>(getGetOrderPaymentUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrderPaymentInfiniteQueryKey = (params?: GetOrderPaymentParams,) => {
    return [
    'infinite', `/order/payment`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrderPaymentQueryKey = (params?: GetOrderPaymentParams,) => {
    return [
    `/order/payment`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrderPaymentInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrderPayment>>>, TError = ErrorType<unknown>>(params?: GetOrderPaymentParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrderPaymentInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrderPayment>>> = ({ signal }) => getOrderPayment(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrderPaymentInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrderPayment>>>
export type GetOrderPaymentInfiniteQueryError = ErrorType<unknown>


export function useGetOrderPaymentInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderPayment>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrderPaymentParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderPayment>>,
          TError,
          Awaited<ReturnType<typeof getOrderPayment>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderPaymentInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderPayment>>>, TError = ErrorType<unknown>>(
 params?: GetOrderPaymentParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderPayment>>,
          TError,
          Awaited<ReturnType<typeof getOrderPayment>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderPaymentInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderPayment>>>, TError = ErrorType<unknown>>(
 params?: GetOrderPaymentParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrderPaymentInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrderPayment>>>, TError = ErrorType<unknown>>(
 params?: GetOrderPaymentParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrderPaymentInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrderPaymentInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrderPayment>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrderPaymentParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrderPaymentInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrderPaymentQueryOptions = <TData = Awaited<ReturnType<typeof getOrderPayment>>, TError = ErrorType<unknown>>(params?: GetOrderPaymentParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrderPaymentQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrderPayment>>> = ({ signal }) => getOrderPayment(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrderPaymentQueryResult = NonNullable<Awaited<ReturnType<typeof getOrderPayment>>>
export type GetOrderPaymentQueryError = ErrorType<unknown>


export function useGetOrderPayment<TData = Awaited<ReturnType<typeof getOrderPayment>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrderPaymentParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderPayment>>,
          TError,
          Awaited<ReturnType<typeof getOrderPayment>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderPayment<TData = Awaited<ReturnType<typeof getOrderPayment>>, TError = ErrorType<unknown>>(
 params?: GetOrderPaymentParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrderPayment>>,
          TError,
          Awaited<ReturnType<typeof getOrderPayment>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrderPayment<TData = Awaited<ReturnType<typeof getOrderPayment>>, TError = ErrorType<unknown>>(
 params?: GetOrderPaymentParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrderPayment<TData = Awaited<ReturnType<typeof getOrderPayment>>, TError = ErrorType<unknown>>(
 params?: GetOrderPaymentParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrderPaymentQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrderPaymentQuery = async <TData = Awaited<ReturnType<typeof getOrderPayment>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrderPaymentParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrderPayment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrderPaymentQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postOrderPaymentResponse200 = {
  data: Response
  status: 200
}
    
export type postOrderPaymentResponseSuccess = (postOrderPaymentResponse200) & {
  headers: Headers;
};
;

export type postOrderPaymentResponse = (postOrderPaymentResponseSuccess)

export const getPostOrderPaymentUrl = () => {


  

  return `/order/payment`
}

export const postOrderPayment = async (orderPayment: OrderPayment[], options?: RequestInit): Promise<postOrderPaymentResponse> => {
  
  return useCustomClient<postOrderPaymentResponse>(getPostOrderPaymentUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      orderPayment,)
  }
);}




export const getPostOrderPaymentMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrderPayment>>, TError,{data: BodyType<OrderPayment[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrderPayment>>, TError,{data: BodyType<OrderPayment[]>}, TContext> => {

const mutationKey = ['postOrderPayment'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrderPayment>>, {data: BodyType<OrderPayment[]>}> = (props) => {
          const {data} = props ?? {};

          return  postOrderPayment(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrderPaymentMutationResult = NonNullable<Awaited<ReturnType<typeof postOrderPayment>>>
    export type PostOrderPaymentMutationBody = BodyType<OrderPayment[]>
    export type PostOrderPaymentMutationError = ErrorType<unknown>

    export const usePostOrderPayment = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrderPayment>>, TError,{data: BodyType<OrderPayment[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrderPayment>>,
        TError,
        {data: BodyType<OrderPayment[]>},
        TContext
      > => {

      const mutationOptions = getPostOrderPaymentMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putOrderPaymentResponse200 = {
  data: Response
  status: 200
}
    
export type putOrderPaymentResponseSuccess = (putOrderPaymentResponse200) & {
  headers: Headers;
};
;

export type putOrderPaymentResponse = (putOrderPaymentResponseSuccess)

export const getPutOrderPaymentUrl = (params: PutOrderPaymentParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/order/payment?${stringifiedParams}` : `/order/payment`
}

export const putOrderPayment = async (orderPaymentBody: OrderPaymentBody,
    params: PutOrderPaymentParams, options?: RequestInit): Promise<putOrderPaymentResponse> => {
  
  return useCustomClient<putOrderPaymentResponse>(getPutOrderPaymentUrl(params),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      orderPaymentBody,)
  }
);}




export const getPutOrderPaymentMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrderPayment>>, TError,{data: BodyType<OrderPaymentBody>;params: PutOrderPaymentParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putOrderPayment>>, TError,{data: BodyType<OrderPaymentBody>;params: PutOrderPaymentParams}, TContext> => {

const mutationKey = ['putOrderPayment'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putOrderPayment>>, {data: BodyType<OrderPaymentBody>;params: PutOrderPaymentParams}> = (props) => {
          const {data,params} = props ?? {};

          return  putOrderPayment(data,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutOrderPaymentMutationResult = NonNullable<Awaited<ReturnType<typeof putOrderPayment>>>
    export type PutOrderPaymentMutationBody = BodyType<OrderPaymentBody>
    export type PutOrderPaymentMutationError = ErrorType<unknown>

    export const usePutOrderPayment = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrderPayment>>, TError,{data: BodyType<OrderPaymentBody>;params: PutOrderPaymentParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putOrderPayment>>,
        TError,
        {data: BodyType<OrderPaymentBody>;params: PutOrderPaymentParams},
        TContext
      > => {

      const mutationOptions = getPutOrderPaymentMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteOrderPaymentResponse200 = {
  data: Response
  status: 200
}
    
export type deleteOrderPaymentResponseSuccess = (deleteOrderPaymentResponse200) & {
  headers: Headers;
};
;

export type deleteOrderPaymentResponse = (deleteOrderPaymentResponseSuccess)

export const getDeleteOrderPaymentUrl = (params: DeleteOrderPaymentParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/order/payment?${stringifiedParams}` : `/order/payment`
}

export const deleteOrderPayment = async (params: DeleteOrderPaymentParams, options?: RequestInit): Promise<deleteOrderPaymentResponse> => {
  
  return useCustomClient<deleteOrderPaymentResponse>(getDeleteOrderPaymentUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteOrderPaymentMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrderPayment>>, TError,{params: DeleteOrderPaymentParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteOrderPayment>>, TError,{params: DeleteOrderPaymentParams}, TContext> => {

const mutationKey = ['deleteOrderPayment'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteOrderPayment>>, {params: DeleteOrderPaymentParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteOrderPayment(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteOrderPaymentMutationResult = NonNullable<Awaited<ReturnType<typeof deleteOrderPayment>>>
    
    export type DeleteOrderPaymentMutationError = ErrorType<unknown>

    export const useDeleteOrderPayment = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrderPayment>>, TError,{params: DeleteOrderPaymentParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteOrderPayment>>,
        TError,
        {params: DeleteOrderPaymentParams},
        TContext
      > => {

      const mutationOptions = getDeleteOrderPaymentMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    