/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  DeleteOrganizationsClubMyJoinedClubsParams,
  DeleteOrganizationsParams,
  EventArrayBody,
  GetOrganizationsClubEventsParams,
  GetOrganizationsClubMyEventsParams,
  GetOrganizationsClubMyJoinedClubsParams,
  GetOrganizationsClubValidationParams,
  GetOrganizationsGetAllOrgFavoritesParams,
  GetOrganizationsParams,
  GetOrganizationsValidationParams,
  Organization,
  OrganizationBody,
  OrganizationClub,
  OrganizationValidationBody,
  PostOrganizationsAddMembershipFeesBody,
  PostOrganizationsCheckAccountsBody,
  PostOrganizationsExportOrgsWithInfoParams,
  PutOrganizationsMyOrgBody,
  PutOrganizationsParams,
  Response,
  UserClubBody
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Get
 */
export type getOrganizationsIdResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsIdResponseSuccess = (getOrganizationsIdResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsIdResponse = (getOrganizationsIdResponseSuccess)

export const getGetOrganizationsIdUrl = (id: string,) => {


  

  return `/organizations/${id}`
}

export const getOrganizationsId = async (id: string, options?: RequestInit): Promise<getOrganizationsIdResponse> => {
  
  return useCustomClient<getOrganizationsIdResponse>(getGetOrganizationsIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/organizations/${id}`
    ] as const;
    }

export const getGetOrganizationsIdQueryKey = (id?: string,) => {
    return [
    `/organizations/${id}`
    ] as const;
    }

    
export const getGetOrganizationsIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsId>>> = ({ signal }) => getOrganizationsId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsId>>>
export type GetOrganizationsIdInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsIdQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsId>>> = ({ signal }) => getOrganizationsId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsIdQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsId>>>
export type GetOrganizationsIdQueryError = ErrorType<unknown>


export function useGetOrganizationsId<TData = Awaited<ReturnType<typeof getOrganizationsId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsId<TData = Awaited<ReturnType<typeof getOrganizationsId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsId<TData = Awaited<ReturnType<typeof getOrganizationsId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsId<TData = Awaited<ReturnType<typeof getOrganizationsId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsIdQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putOrganizationsIdResponse200 = {
  data: Response
  status: 200
}
    
export type putOrganizationsIdResponseSuccess = (putOrganizationsIdResponse200) & {
  headers: Headers;
};
;

export type putOrganizationsIdResponse = (putOrganizationsIdResponseSuccess)

export const getPutOrganizationsIdUrl = (id: string,) => {


  

  return `/organizations/${id}`
}

export const putOrganizationsId = async (id: string,
    organizationBody: OrganizationBody, options?: RequestInit): Promise<putOrganizationsIdResponse> => {
  
  return useCustomClient<putOrganizationsIdResponse>(getPutOrganizationsIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationBody,)
  }
);}




export const getPutOrganizationsIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationsId>>, TError,{id: string;data: BodyType<OrganizationBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putOrganizationsId>>, TError,{id: string;data: BodyType<OrganizationBody>}, TContext> => {

const mutationKey = ['putOrganizationsId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putOrganizationsId>>, {id: string;data: BodyType<OrganizationBody>}> = (props) => {
          const {id,data} = props ?? {};

          return  putOrganizationsId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutOrganizationsIdMutationResult = NonNullable<Awaited<ReturnType<typeof putOrganizationsId>>>
    export type PutOrganizationsIdMutationBody = BodyType<OrganizationBody>
    export type PutOrganizationsIdMutationError = ErrorType<unknown>

    export const usePutOrganizationsId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationsId>>, TError,{id: string;data: BodyType<OrganizationBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putOrganizationsId>>,
        TError,
        {id: string;data: BodyType<OrganizationBody>},
        TContext
      > => {

      const mutationOptions = getPutOrganizationsIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteOrganizationsIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteOrganizationsIdResponseSuccess = (deleteOrganizationsIdResponse200) & {
  headers: Headers;
};
;

export type deleteOrganizationsIdResponse = (deleteOrganizationsIdResponseSuccess)

export const getDeleteOrganizationsIdUrl = (id: string,) => {


  

  return `/organizations/${id}`
}

export const deleteOrganizationsId = async (id: string, options?: RequestInit): Promise<deleteOrganizationsIdResponse> => {
  
  return useCustomClient<deleteOrganizationsIdResponse>(getDeleteOrganizationsIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteOrganizationsIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationsId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationsId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteOrganizationsId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteOrganizationsId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteOrganizationsId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteOrganizationsIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteOrganizationsId>>>
    
    export type DeleteOrganizationsIdMutationError = ErrorType<unknown>

    export const useDeleteOrganizationsId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationsId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteOrganizationsId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteOrganizationsIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrganizationsIdJoinedClubsResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsIdJoinedClubsResponseSuccess = (getOrganizationsIdJoinedClubsResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsIdJoinedClubsResponse = (getOrganizationsIdJoinedClubsResponseSuccess)

export const getGetOrganizationsIdJoinedClubsUrl = (id: string,) => {


  

  return `/organizations/${id}/joinedClubs`
}

export const getOrganizationsIdJoinedClubs = async (id: string, options?: RequestInit): Promise<getOrganizationsIdJoinedClubsResponse> => {
  
  return useCustomClient<getOrganizationsIdJoinedClubsResponse>(getGetOrganizationsIdJoinedClubsUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsIdJoinedClubsInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/organizations/${id}/joinedClubs`
    ] as const;
    }

export const getGetOrganizationsIdJoinedClubsQueryKey = (id?: string,) => {
    return [
    `/organizations/${id}/joinedClubs`
    ] as const;
    }

    
export const getGetOrganizationsIdJoinedClubsInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsIdJoinedClubsInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>> = ({ signal }) => getOrganizationsIdJoinedClubs(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsIdJoinedClubsInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>>
export type GetOrganizationsIdJoinedClubsInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsIdJoinedClubsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsIdJoinedClubsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsIdJoinedClubsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsIdJoinedClubsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsIdJoinedClubsInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsIdJoinedClubsInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsIdJoinedClubsInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsIdJoinedClubsQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsIdJoinedClubsQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>> = ({ signal }) => getOrganizationsIdJoinedClubs(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsIdJoinedClubsQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>>
export type GetOrganizationsIdJoinedClubsQueryError = ErrorType<unknown>


export function useGetOrganizationsIdJoinedClubs<TData = Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsIdJoinedClubs<TData = Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsIdJoinedClubs<TData = Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsIdJoinedClubs<TData = Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsIdJoinedClubsQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsIdJoinedClubsQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsIdJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsIdJoinedClubsQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Add membership fees for existing organizations by tax codes
 */
export type postOrganizationsAddMembershipFeesResponse200 = {
  data: Response
  status: 200
}
    
export type postOrganizationsAddMembershipFeesResponseSuccess = (postOrganizationsAddMembershipFeesResponse200) & {
  headers: Headers;
};
;

export type postOrganizationsAddMembershipFeesResponse = (postOrganizationsAddMembershipFeesResponseSuccess)

export const getPostOrganizationsAddMembershipFeesUrl = () => {


  

  return `/organizations/add-membership-fees`
}

export const postOrganizationsAddMembershipFees = async (postOrganizationsAddMembershipFeesBody: PostOrganizationsAddMembershipFeesBody, options?: RequestInit): Promise<postOrganizationsAddMembershipFeesResponse> => {
  
  return useCustomClient<postOrganizationsAddMembershipFeesResponse>(getPostOrganizationsAddMembershipFeesUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      postOrganizationsAddMembershipFeesBody,)
  }
);}




export const getPostOrganizationsAddMembershipFeesMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsAddMembershipFees>>, TError,{data: BodyType<PostOrganizationsAddMembershipFeesBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsAddMembershipFees>>, TError,{data: BodyType<PostOrganizationsAddMembershipFeesBody>}, TContext> => {

const mutationKey = ['postOrganizationsAddMembershipFees'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrganizationsAddMembershipFees>>, {data: BodyType<PostOrganizationsAddMembershipFeesBody>}> = (props) => {
          const {data} = props ?? {};

          return  postOrganizationsAddMembershipFees(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrganizationsAddMembershipFeesMutationResult = NonNullable<Awaited<ReturnType<typeof postOrganizationsAddMembershipFees>>>
    export type PostOrganizationsAddMembershipFeesMutationBody = BodyType<PostOrganizationsAddMembershipFeesBody>
    export type PostOrganizationsAddMembershipFeesMutationError = ErrorType<unknown>

    export const usePostOrganizationsAddMembershipFees = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsAddMembershipFees>>, TError,{data: BodyType<PostOrganizationsAddMembershipFeesBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrganizationsAddMembershipFees>>,
        TError,
        {data: BodyType<PostOrganizationsAddMembershipFeesBody>},
        TContext
      > => {

      const mutationOptions = getPostOrganizationsAddMembershipFeesMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Check if organizations have user accounts by tax codes
 */
export type postOrganizationsCheckAccountsResponse200 = {
  data: Response
  status: 200
}
    
export type postOrganizationsCheckAccountsResponseSuccess = (postOrganizationsCheckAccountsResponse200) & {
  headers: Headers;
};
;

export type postOrganizationsCheckAccountsResponse = (postOrganizationsCheckAccountsResponseSuccess)

export const getPostOrganizationsCheckAccountsUrl = () => {


  

  return `/organizations/check-accounts`
}

export const postOrganizationsCheckAccounts = async (postOrganizationsCheckAccountsBody: PostOrganizationsCheckAccountsBody, options?: RequestInit): Promise<postOrganizationsCheckAccountsResponse> => {
  
  return useCustomClient<postOrganizationsCheckAccountsResponse>(getPostOrganizationsCheckAccountsUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      postOrganizationsCheckAccountsBody,)
  }
);}




export const getPostOrganizationsCheckAccountsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsCheckAccounts>>, TError,{data: BodyType<PostOrganizationsCheckAccountsBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsCheckAccounts>>, TError,{data: BodyType<PostOrganizationsCheckAccountsBody>}, TContext> => {

const mutationKey = ['postOrganizationsCheckAccounts'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrganizationsCheckAccounts>>, {data: BodyType<PostOrganizationsCheckAccountsBody>}> = (props) => {
          const {data} = props ?? {};

          return  postOrganizationsCheckAccounts(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrganizationsCheckAccountsMutationResult = NonNullable<Awaited<ReturnType<typeof postOrganizationsCheckAccounts>>>
    export type PostOrganizationsCheckAccountsMutationBody = BodyType<PostOrganizationsCheckAccountsBody>
    export type PostOrganizationsCheckAccountsMutationError = ErrorType<unknown>

    export const usePostOrganizationsCheckAccounts = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsCheckAccounts>>, TError,{data: BodyType<PostOrganizationsCheckAccountsBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrganizationsCheckAccounts>>,
        TError,
        {data: BodyType<PostOrganizationsCheckAccountsBody>},
        TContext
      > => {

      const mutationOptions = getPostOrganizationsCheckAccountsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrganizationsClubEventsResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsClubEventsResponseSuccess = (getOrganizationsClubEventsResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsClubEventsResponse = (getOrganizationsClubEventsResponseSuccess)

export const getGetOrganizationsClubEventsUrl = (params?: GetOrganizationsClubEventsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organizations/club/events?${stringifiedParams}` : `/organizations/club/events`
}

export const getOrganizationsClubEvents = async (params?: GetOrganizationsClubEventsParams, options?: RequestInit): Promise<getOrganizationsClubEventsResponse> => {
  
  return useCustomClient<getOrganizationsClubEventsResponse>(getGetOrganizationsClubEventsUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsClubEventsInfiniteQueryKey = (params?: GetOrganizationsClubEventsParams,) => {
    return [
    'infinite', `/organizations/club/events`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrganizationsClubEventsQueryKey = (params?: GetOrganizationsClubEventsParams,) => {
    return [
    `/organizations/club/events`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrganizationsClubEventsInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubEvents>>>, TError = ErrorType<unknown>>(params?: GetOrganizationsClubEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubEventsInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubEvents>>> = ({ signal }) => getOrganizationsClubEvents(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubEventsInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubEvents>>>
export type GetOrganizationsClubEventsInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsClubEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubEvents>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsClubEventsParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubEvents>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubEvents>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubEvents>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubEvents>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubEvents>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubEventsInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubEventsInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsClubEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubEventsInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsClubEventsQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError = ErrorType<unknown>>(params?: GetOrganizationsClubEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubEventsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubEvents>>> = ({ signal }) => getOrganizationsClubEvents(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubEventsQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubEvents>>>
export type GetOrganizationsClubEventsQueryError = ErrorType<unknown>


export function useGetOrganizationsClubEvents<TData = Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsClubEventsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubEvents>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubEvents<TData = Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubEvents>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubEvents<TData = Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubEvents<TData = Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubEventsQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubEventsQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsClubEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubEventsQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postOrganizationsClubEventsResponse200 = {
  data: Response
  status: 200
}
    
export type postOrganizationsClubEventsResponseSuccess = (postOrganizationsClubEventsResponse200) & {
  headers: Headers;
};
;

export type postOrganizationsClubEventsResponse = (postOrganizationsClubEventsResponseSuccess)

export const getPostOrganizationsClubEventsUrl = () => {


  

  return `/organizations/club/events`
}

export const postOrganizationsClubEvents = async (eventArrayBody: EventArrayBody, options?: RequestInit): Promise<postOrganizationsClubEventsResponse> => {
  
  return useCustomClient<postOrganizationsClubEventsResponse>(getPostOrganizationsClubEventsUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      eventArrayBody,)
  }
);}




export const getPostOrganizationsClubEventsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsClubEvents>>, TError,{data: BodyType<EventArrayBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsClubEvents>>, TError,{data: BodyType<EventArrayBody>}, TContext> => {

const mutationKey = ['postOrganizationsClubEvents'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrganizationsClubEvents>>, {data: BodyType<EventArrayBody>}> = (props) => {
          const {data} = props ?? {};

          return  postOrganizationsClubEvents(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrganizationsClubEventsMutationResult = NonNullable<Awaited<ReturnType<typeof postOrganizationsClubEvents>>>
    export type PostOrganizationsClubEventsMutationBody = BodyType<EventArrayBody>
    export type PostOrganizationsClubEventsMutationError = ErrorType<unknown>

    export const usePostOrganizationsClubEvents = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsClubEvents>>, TError,{data: BodyType<EventArrayBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrganizationsClubEvents>>,
        TError,
        {data: BodyType<EventArrayBody>},
        TContext
      > => {

      const mutationOptions = getPostOrganizationsClubEventsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putOrganizationsClubResponse200 = {
  data: Response
  status: 200
}
    
export type putOrganizationsClubResponseSuccess = (putOrganizationsClubResponse200) & {
  headers: Headers;
};
;

export type putOrganizationsClubResponse = (putOrganizationsClubResponseSuccess)

export const getPutOrganizationsClubUrl = () => {


  

  return `/organizations/club`
}

export const putOrganizationsClub = async (userClubBody: UserClubBody, options?: RequestInit): Promise<putOrganizationsClubResponse> => {
  
  return useCustomClient<putOrganizationsClubResponse>(getPutOrganizationsClubUrl(),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      userClubBody,)
  }
);}




export const getPutOrganizationsClubMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationsClub>>, TError,{data: BodyType<UserClubBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putOrganizationsClub>>, TError,{data: BodyType<UserClubBody>}, TContext> => {

const mutationKey = ['putOrganizationsClub'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putOrganizationsClub>>, {data: BodyType<UserClubBody>}> = (props) => {
          const {data} = props ?? {};

          return  putOrganizationsClub(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutOrganizationsClubMutationResult = NonNullable<Awaited<ReturnType<typeof putOrganizationsClub>>>
    export type PutOrganizationsClubMutationBody = BodyType<UserClubBody>
    export type PutOrganizationsClubMutationError = ErrorType<unknown>

    export const usePutOrganizationsClub = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationsClub>>, TError,{data: BodyType<UserClubBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putOrganizationsClub>>,
        TError,
        {data: BodyType<UserClubBody>},
        TContext
      > => {

      const mutationOptions = getPutOrganizationsClubMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrganizationsClubMembersClubIdResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsClubMembersClubIdResponseSuccess = (getOrganizationsClubMembersClubIdResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsClubMembersClubIdResponse = (getOrganizationsClubMembersClubIdResponseSuccess)

export const getGetOrganizationsClubMembersClubIdUrl = (clubId: string,) => {


  

  return `/organizations/club/members/${clubId}`
}

export const getOrganizationsClubMembersClubId = async (clubId: string, options?: RequestInit): Promise<getOrganizationsClubMembersClubIdResponse> => {
  
  return useCustomClient<getOrganizationsClubMembersClubIdResponse>(getGetOrganizationsClubMembersClubIdUrl(clubId),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsClubMembersClubIdInfiniteQueryKey = (clubId?: string,) => {
    return [
    'infinite', `/organizations/club/members/${clubId}`
    ] as const;
    }

export const getGetOrganizationsClubMembersClubIdQueryKey = (clubId?: string,) => {
    return [
    `/organizations/club/members/${clubId}`
    ] as const;
    }

    
export const getGetOrganizationsClubMembersClubIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>>, TError = ErrorType<unknown>>(clubId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubMembersClubIdInfiniteQueryKey(clubId);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>> = ({ signal }) => getOrganizationsClubMembersClubId(clubId, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(clubId),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubMembersClubIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>>
export type GetOrganizationsClubMembersClubIdInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsClubMembersClubIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>>, TError = ErrorType<unknown>>(
 clubId: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMembersClubIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>>, TError = ErrorType<unknown>>(
 clubId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMembersClubIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>>, TError = ErrorType<unknown>>(
 clubId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubMembersClubIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>>, TError = ErrorType<unknown>>(
 clubId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubMembersClubIdInfiniteQueryOptions(clubId,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubMembersClubIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, clubId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubMembersClubIdInfiniteQueryOptions(clubId,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsClubMembersClubIdQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError = ErrorType<unknown>>(clubId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubMembersClubIdQueryKey(clubId);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>> = ({ signal }) => getOrganizationsClubMembersClubId(clubId, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(clubId),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubMembersClubIdQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>>
export type GetOrganizationsClubMembersClubIdQueryError = ErrorType<unknown>


export function useGetOrganizationsClubMembersClubId<TData = Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError = ErrorType<unknown>>(
 clubId: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMembersClubId<TData = Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError = ErrorType<unknown>>(
 clubId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMembersClubId<TData = Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError = ErrorType<unknown>>(
 clubId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubMembersClubId<TData = Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError = ErrorType<unknown>>(
 clubId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubMembersClubIdQueryOptions(clubId,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubMembersClubIdQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, clubId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembersClubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubMembersClubIdQueryOptions(clubId,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getOrganizationsClubMembersResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsClubMembersResponseSuccess = (getOrganizationsClubMembersResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsClubMembersResponse = (getOrganizationsClubMembersResponseSuccess)

export const getGetOrganizationsClubMembersUrl = () => {


  

  return `/organizations/club/members`
}

export const getOrganizationsClubMembers = async ( options?: RequestInit): Promise<getOrganizationsClubMembersResponse> => {
  
  return useCustomClient<getOrganizationsClubMembersResponse>(getGetOrganizationsClubMembersUrl(),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsClubMembersInfiniteQueryKey = () => {
    return [
    'infinite', `/organizations/club/members`
    ] as const;
    }

export const getGetOrganizationsClubMembersQueryKey = () => {
    return [
    `/organizations/club/members`
    ] as const;
    }

    
export const getGetOrganizationsClubMembersInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMembers>>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubMembersInfiniteQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubMembers>>> = ({ signal }) => getOrganizationsClubMembers({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubMembersInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubMembers>>>
export type GetOrganizationsClubMembersInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsClubMembersInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMembers>>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMembers>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMembers>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMembersInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMembers>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMembers>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMembers>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMembersInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMembers>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubMembersInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMembers>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubMembersInfiniteQueryOptions(options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubMembersInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubMembersInfiniteQueryOptions(options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsClubMembersQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubMembersQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubMembers>>> = ({ signal }) => getOrganizationsClubMembers({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubMembersQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubMembers>>>
export type GetOrganizationsClubMembersQueryError = ErrorType<unknown>


export function useGetOrganizationsClubMembers<TData = Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMembers>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMembers>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMembers<TData = Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMembers>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMembers>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMembers<TData = Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubMembers<TData = Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubMembersQueryOptions(options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubMembersQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMembers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubMembersQueryOptions(options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getOrganizationsClubMyClubResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsClubMyClubResponseSuccess = (getOrganizationsClubMyClubResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsClubMyClubResponse = (getOrganizationsClubMyClubResponseSuccess)

export const getGetOrganizationsClubMyClubUrl = () => {


  

  return `/organizations/club/myClub`
}

export const getOrganizationsClubMyClub = async ( options?: RequestInit): Promise<getOrganizationsClubMyClubResponse> => {
  
  return useCustomClient<getOrganizationsClubMyClubResponse>(getGetOrganizationsClubMyClubUrl(),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsClubMyClubInfiniteQueryKey = () => {
    return [
    'infinite', `/organizations/club/myClub`
    ] as const;
    }

export const getGetOrganizationsClubMyClubQueryKey = () => {
    return [
    `/organizations/club/myClub`
    ] as const;
    }

    
export const getGetOrganizationsClubMyClubInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubMyClubInfiniteQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>> = ({ signal }) => getOrganizationsClubMyClub({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubMyClubInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>>
export type GetOrganizationsClubMyClubInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsClubMyClubInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMyClub>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMyClub>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMyClubInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMyClub>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMyClub>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMyClubInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubMyClubInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubMyClubInfiniteQueryOptions(options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubMyClubInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubMyClubInfiniteQueryOptions(options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsClubMyClubQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubMyClubQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>> = ({ signal }) => getOrganizationsClubMyClub({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubMyClubQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>>
export type GetOrganizationsClubMyClubQueryError = ErrorType<unknown>


export function useGetOrganizationsClubMyClub<TData = Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMyClub>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMyClub>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMyClub<TData = Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMyClub>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMyClub>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMyClub<TData = Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubMyClub<TData = Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubMyClubQueryOptions(options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubMyClubQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubMyClubQueryOptions(options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putOrganizationsClubMyClubResponse200 = {
  data: Response
  status: 200
}
    
export type putOrganizationsClubMyClubResponseSuccess = (putOrganizationsClubMyClubResponse200) & {
  headers: Headers;
};
;

export type putOrganizationsClubMyClubResponse = (putOrganizationsClubMyClubResponseSuccess)

export const getPutOrganizationsClubMyClubUrl = () => {


  

  return `/organizations/club/myClub`
}

export const putOrganizationsClubMyClub = async (organizationBody: OrganizationBody, options?: RequestInit): Promise<putOrganizationsClubMyClubResponse> => {
  
  return useCustomClient<putOrganizationsClubMyClubResponse>(getPutOrganizationsClubMyClubUrl(),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationBody,)
  }
);}




export const getPutOrganizationsClubMyClubMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationsClubMyClub>>, TError,{data: BodyType<OrganizationBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putOrganizationsClubMyClub>>, TError,{data: BodyType<OrganizationBody>}, TContext> => {

const mutationKey = ['putOrganizationsClubMyClub'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putOrganizationsClubMyClub>>, {data: BodyType<OrganizationBody>}> = (props) => {
          const {data} = props ?? {};

          return  putOrganizationsClubMyClub(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutOrganizationsClubMyClubMutationResult = NonNullable<Awaited<ReturnType<typeof putOrganizationsClubMyClub>>>
    export type PutOrganizationsClubMyClubMutationBody = BodyType<OrganizationBody>
    export type PutOrganizationsClubMyClubMutationError = ErrorType<unknown>

    export const usePutOrganizationsClubMyClub = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationsClubMyClub>>, TError,{data: BodyType<OrganizationBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putOrganizationsClubMyClub>>,
        TError,
        {data: BodyType<OrganizationBody>},
        TContext
      > => {

      const mutationOptions = getPutOrganizationsClubMyClubMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrganizationsClubMyEventsResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsClubMyEventsResponseSuccess = (getOrganizationsClubMyEventsResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsClubMyEventsResponse = (getOrganizationsClubMyEventsResponseSuccess)

export const getGetOrganizationsClubMyEventsUrl = (params?: GetOrganizationsClubMyEventsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organizations/club/myEvents?${stringifiedParams}` : `/organizations/club/myEvents`
}

export const getOrganizationsClubMyEvents = async (params?: GetOrganizationsClubMyEventsParams, options?: RequestInit): Promise<getOrganizationsClubMyEventsResponse> => {
  
  return useCustomClient<getOrganizationsClubMyEventsResponse>(getGetOrganizationsClubMyEventsUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsClubMyEventsInfiniteQueryKey = (params?: GetOrganizationsClubMyEventsParams,) => {
    return [
    'infinite', `/organizations/club/myEvents`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrganizationsClubMyEventsQueryKey = (params?: GetOrganizationsClubMyEventsParams,) => {
    return [
    `/organizations/club/myEvents`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrganizationsClubMyEventsInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>>, TError = ErrorType<unknown>>(params?: GetOrganizationsClubMyEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubMyEventsInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>> = ({ signal }) => getOrganizationsClubMyEvents(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubMyEventsInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>>
export type GetOrganizationsClubMyEventsInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsClubMyEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsClubMyEventsParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMyEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubMyEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMyEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubMyEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubMyEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubMyEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubMyEventsInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubMyEventsInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsClubMyEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubMyEventsInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsClubMyEventsQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError = ErrorType<unknown>>(params?: GetOrganizationsClubMyEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubMyEventsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>> = ({ signal }) => getOrganizationsClubMyEvents(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubMyEventsQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>>
export type GetOrganizationsClubMyEventsQueryError = ErrorType<unknown>


export function useGetOrganizationsClubMyEvents<TData = Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsClubMyEventsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMyEvents<TData = Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubMyEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMyEvents<TData = Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubMyEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubMyEvents<TData = Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubMyEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubMyEventsQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubMyEventsQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsClubMyEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubMyEventsQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getOrganizationsClubMyJoinedClubsResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsClubMyJoinedClubsResponseSuccess = (getOrganizationsClubMyJoinedClubsResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsClubMyJoinedClubsResponse = (getOrganizationsClubMyJoinedClubsResponseSuccess)

export const getGetOrganizationsClubMyJoinedClubsUrl = (params?: GetOrganizationsClubMyJoinedClubsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organizations/club/myJoinedClubs?${stringifiedParams}` : `/organizations/club/myJoinedClubs`
}

export const getOrganizationsClubMyJoinedClubs = async (params?: GetOrganizationsClubMyJoinedClubsParams, options?: RequestInit): Promise<getOrganizationsClubMyJoinedClubsResponse> => {
  
  return useCustomClient<getOrganizationsClubMyJoinedClubsResponse>(getGetOrganizationsClubMyJoinedClubsUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsClubMyJoinedClubsInfiniteQueryKey = (params?: GetOrganizationsClubMyJoinedClubsParams,) => {
    return [
    'infinite', `/organizations/club/myJoinedClubs`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrganizationsClubMyJoinedClubsQueryKey = (params?: GetOrganizationsClubMyJoinedClubsParams,) => {
    return [
    `/organizations/club/myJoinedClubs`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrganizationsClubMyJoinedClubsInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>>, TError = ErrorType<unknown>>(params?: GetOrganizationsClubMyJoinedClubsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubMyJoinedClubsInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>> = ({ signal }) => getOrganizationsClubMyJoinedClubs(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubMyJoinedClubsInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>>
export type GetOrganizationsClubMyJoinedClubsInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsClubMyJoinedClubsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsClubMyJoinedClubsParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMyJoinedClubsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubMyJoinedClubsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMyJoinedClubsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubMyJoinedClubsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubMyJoinedClubsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubMyJoinedClubsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubMyJoinedClubsInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubMyJoinedClubsInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsClubMyJoinedClubsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubMyJoinedClubsInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsClubMyJoinedClubsQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError = ErrorType<unknown>>(params?: GetOrganizationsClubMyJoinedClubsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubMyJoinedClubsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>> = ({ signal }) => getOrganizationsClubMyJoinedClubs(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubMyJoinedClubsQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>>
export type GetOrganizationsClubMyJoinedClubsQueryError = ErrorType<unknown>


export function useGetOrganizationsClubMyJoinedClubs<TData = Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsClubMyJoinedClubsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMyJoinedClubs<TData = Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubMyJoinedClubsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubMyJoinedClubs<TData = Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubMyJoinedClubsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubMyJoinedClubs<TData = Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubMyJoinedClubsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubMyJoinedClubsQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubMyJoinedClubsQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsClubMyJoinedClubsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubMyJoinedClubs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubMyJoinedClubsQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postOrganizationsClubMyJoinedClubsResponse200 = {
  data: Response
  status: 200
}
    
export type postOrganizationsClubMyJoinedClubsResponseSuccess = (postOrganizationsClubMyJoinedClubsResponse200) & {
  headers: Headers;
};
;

export type postOrganizationsClubMyJoinedClubsResponse = (postOrganizationsClubMyJoinedClubsResponseSuccess)

export const getPostOrganizationsClubMyJoinedClubsUrl = () => {


  

  return `/organizations/club/myJoinedClubs`
}

export const postOrganizationsClubMyJoinedClubs = async (organizationClub: OrganizationClub[], options?: RequestInit): Promise<postOrganizationsClubMyJoinedClubsResponse> => {
  
  return useCustomClient<postOrganizationsClubMyJoinedClubsResponse>(getPostOrganizationsClubMyJoinedClubsUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationClub,)
  }
);}




export const getPostOrganizationsClubMyJoinedClubsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsClubMyJoinedClubs>>, TError,{data: BodyType<OrganizationClub[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsClubMyJoinedClubs>>, TError,{data: BodyType<OrganizationClub[]>}, TContext> => {

const mutationKey = ['postOrganizationsClubMyJoinedClubs'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrganizationsClubMyJoinedClubs>>, {data: BodyType<OrganizationClub[]>}> = (props) => {
          const {data} = props ?? {};

          return  postOrganizationsClubMyJoinedClubs(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrganizationsClubMyJoinedClubsMutationResult = NonNullable<Awaited<ReturnType<typeof postOrganizationsClubMyJoinedClubs>>>
    export type PostOrganizationsClubMyJoinedClubsMutationBody = BodyType<OrganizationClub[]>
    export type PostOrganizationsClubMyJoinedClubsMutationError = ErrorType<unknown>

    export const usePostOrganizationsClubMyJoinedClubs = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsClubMyJoinedClubs>>, TError,{data: BodyType<OrganizationClub[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrganizationsClubMyJoinedClubs>>,
        TError,
        {data: BodyType<OrganizationClub[]>},
        TContext
      > => {

      const mutationOptions = getPostOrganizationsClubMyJoinedClubsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteOrganizationsClubMyJoinedClubsResponse200 = {
  data: Response
  status: 200
}
    
export type deleteOrganizationsClubMyJoinedClubsResponseSuccess = (deleteOrganizationsClubMyJoinedClubsResponse200) & {
  headers: Headers;
};
;

export type deleteOrganizationsClubMyJoinedClubsResponse = (deleteOrganizationsClubMyJoinedClubsResponseSuccess)

export const getDeleteOrganizationsClubMyJoinedClubsUrl = (params: DeleteOrganizationsClubMyJoinedClubsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organizations/club/myJoinedClubs?${stringifiedParams}` : `/organizations/club/myJoinedClubs`
}

export const deleteOrganizationsClubMyJoinedClubs = async (params: DeleteOrganizationsClubMyJoinedClubsParams, options?: RequestInit): Promise<deleteOrganizationsClubMyJoinedClubsResponse> => {
  
  return useCustomClient<deleteOrganizationsClubMyJoinedClubsResponse>(getDeleteOrganizationsClubMyJoinedClubsUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteOrganizationsClubMyJoinedClubsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationsClubMyJoinedClubs>>, TError,{params: DeleteOrganizationsClubMyJoinedClubsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationsClubMyJoinedClubs>>, TError,{params: DeleteOrganizationsClubMyJoinedClubsParams}, TContext> => {

const mutationKey = ['deleteOrganizationsClubMyJoinedClubs'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteOrganizationsClubMyJoinedClubs>>, {params: DeleteOrganizationsClubMyJoinedClubsParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteOrganizationsClubMyJoinedClubs(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteOrganizationsClubMyJoinedClubsMutationResult = NonNullable<Awaited<ReturnType<typeof deleteOrganizationsClubMyJoinedClubs>>>
    
    export type DeleteOrganizationsClubMyJoinedClubsMutationError = ErrorType<unknown>

    export const useDeleteOrganizationsClubMyJoinedClubs = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationsClubMyJoinedClubs>>, TError,{params: DeleteOrganizationsClubMyJoinedClubsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteOrganizationsClubMyJoinedClubs>>,
        TError,
        {params: DeleteOrganizationsClubMyJoinedClubsParams},
        TContext
      > => {

      const mutationOptions = getDeleteOrganizationsClubMyJoinedClubsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrganizationsClubValidationResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsClubValidationResponseSuccess = (getOrganizationsClubValidationResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsClubValidationResponse = (getOrganizationsClubValidationResponseSuccess)

export const getGetOrganizationsClubValidationUrl = (params?: GetOrganizationsClubValidationParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organizations/club/validation?${stringifiedParams}` : `/organizations/club/validation`
}

export const getOrganizationsClubValidation = async (params?: GetOrganizationsClubValidationParams, options?: RequestInit): Promise<getOrganizationsClubValidationResponse> => {
  
  return useCustomClient<getOrganizationsClubValidationResponse>(getGetOrganizationsClubValidationUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsClubValidationInfiniteQueryKey = (params?: GetOrganizationsClubValidationParams,) => {
    return [
    'infinite', `/organizations/club/validation`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrganizationsClubValidationQueryKey = (params?: GetOrganizationsClubValidationParams,) => {
    return [
    `/organizations/club/validation`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrganizationsClubValidationInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubValidation>>>, TError = ErrorType<unknown>>(params?: GetOrganizationsClubValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubValidationInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubValidation>>> = ({ signal }) => getOrganizationsClubValidation(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubValidationInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubValidation>>>
export type GetOrganizationsClubValidationInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsClubValidationInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubValidation>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsClubValidationParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubValidation>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubValidation>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubValidationInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubValidation>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubValidation>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubValidation>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubValidationInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubValidation>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubValidationInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsClubValidation>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubValidationInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubValidationInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsClubValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubValidationInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsClubValidationQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError = ErrorType<unknown>>(params?: GetOrganizationsClubValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsClubValidationQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsClubValidation>>> = ({ signal }) => getOrganizationsClubValidation(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsClubValidationQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsClubValidation>>>
export type GetOrganizationsClubValidationQueryError = ErrorType<unknown>


export function useGetOrganizationsClubValidation<TData = Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsClubValidationParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubValidation>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubValidation>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubValidation<TData = Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsClubValidation>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsClubValidation>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsClubValidation<TData = Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsClubValidation<TData = Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsClubValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsClubValidationQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsClubValidationQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsClubValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsClubValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsClubValidationQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postOrganizationsClubValidationResponse200 = {
  data: Response
  status: 200
}
    
export type postOrganizationsClubValidationResponseSuccess = (postOrganizationsClubValidationResponse200) & {
  headers: Headers;
};
;

export type postOrganizationsClubValidationResponse = (postOrganizationsClubValidationResponseSuccess)

export const getPostOrganizationsClubValidationUrl = () => {


  

  return `/organizations/club/validation`
}

export const postOrganizationsClubValidation = async (organizationValidationBody: OrganizationValidationBody, options?: RequestInit): Promise<postOrganizationsClubValidationResponse> => {
  
  return useCustomClient<postOrganizationsClubValidationResponse>(getPostOrganizationsClubValidationUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationValidationBody,)
  }
);}




export const getPostOrganizationsClubValidationMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsClubValidation>>, TError,{data: BodyType<OrganizationValidationBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsClubValidation>>, TError,{data: BodyType<OrganizationValidationBody>}, TContext> => {

const mutationKey = ['postOrganizationsClubValidation'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrganizationsClubValidation>>, {data: BodyType<OrganizationValidationBody>}> = (props) => {
          const {data} = props ?? {};

          return  postOrganizationsClubValidation(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrganizationsClubValidationMutationResult = NonNullable<Awaited<ReturnType<typeof postOrganizationsClubValidation>>>
    export type PostOrganizationsClubValidationMutationBody = BodyType<OrganizationValidationBody>
    export type PostOrganizationsClubValidationMutationError = ErrorType<unknown>

    export const usePostOrganizationsClubValidation = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsClubValidation>>, TError,{data: BodyType<OrganizationValidationBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrganizationsClubValidation>>,
        TError,
        {data: BodyType<OrganizationValidationBody>},
        TContext
      > => {

      const mutationOptions = getPostOrganizationsClubValidationMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Export to excel
 */
export type postOrganizationsExportOrgsWithInfoResponse200 = {
  data: Response
  status: 200
}
    
export type postOrganizationsExportOrgsWithInfoResponseSuccess = (postOrganizationsExportOrgsWithInfoResponse200) & {
  headers: Headers;
};
;

export type postOrganizationsExportOrgsWithInfoResponse = (postOrganizationsExportOrgsWithInfoResponseSuccess)

export const getPostOrganizationsExportOrgsWithInfoUrl = (params?: PostOrganizationsExportOrgsWithInfoParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organizations/exportOrgsWithInfo?${stringifiedParams}` : `/organizations/exportOrgsWithInfo`
}

export const postOrganizationsExportOrgsWithInfo = async (params?: PostOrganizationsExportOrgsWithInfoParams, options?: RequestInit): Promise<postOrganizationsExportOrgsWithInfoResponse> => {
  
  return useCustomClient<postOrganizationsExportOrgsWithInfoResponse>(getPostOrganizationsExportOrgsWithInfoUrl(params),
  {      
    ...options,
    method: 'POST'
    
    
  }
);}




export const getPostOrganizationsExportOrgsWithInfoMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsExportOrgsWithInfo>>, TError,{params?: PostOrganizationsExportOrgsWithInfoParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsExportOrgsWithInfo>>, TError,{params?: PostOrganizationsExportOrgsWithInfoParams}, TContext> => {

const mutationKey = ['postOrganizationsExportOrgsWithInfo'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrganizationsExportOrgsWithInfo>>, {params?: PostOrganizationsExportOrgsWithInfoParams}> = (props) => {
          const {params} = props ?? {};

          return  postOrganizationsExportOrgsWithInfo(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrganizationsExportOrgsWithInfoMutationResult = NonNullable<Awaited<ReturnType<typeof postOrganizationsExportOrgsWithInfo>>>
    
    export type PostOrganizationsExportOrgsWithInfoMutationError = ErrorType<unknown>

    export const usePostOrganizationsExportOrgsWithInfo = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsExportOrgsWithInfo>>, TError,{params?: PostOrganizationsExportOrgsWithInfoParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrganizationsExportOrgsWithInfo>>,
        TError,
        {params?: PostOrganizationsExportOrgsWithInfoParams},
        TContext
      > => {

      const mutationOptions = getPostOrganizationsExportOrgsWithInfoMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrganizationsGetAllOrgFavoritesResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsGetAllOrgFavoritesResponseSuccess = (getOrganizationsGetAllOrgFavoritesResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsGetAllOrgFavoritesResponse = (getOrganizationsGetAllOrgFavoritesResponseSuccess)

export const getGetOrganizationsGetAllOrgFavoritesUrl = (params?: GetOrganizationsGetAllOrgFavoritesParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organizations/getAllOrgFavorites?${stringifiedParams}` : `/organizations/getAllOrgFavorites`
}

export const getOrganizationsGetAllOrgFavorites = async (params?: GetOrganizationsGetAllOrgFavoritesParams, options?: RequestInit): Promise<getOrganizationsGetAllOrgFavoritesResponse> => {
  
  return useCustomClient<getOrganizationsGetAllOrgFavoritesResponse>(getGetOrganizationsGetAllOrgFavoritesUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsGetAllOrgFavoritesInfiniteQueryKey = (params?: GetOrganizationsGetAllOrgFavoritesParams,) => {
    return [
    'infinite', `/organizations/getAllOrgFavorites`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrganizationsGetAllOrgFavoritesQueryKey = (params?: GetOrganizationsGetAllOrgFavoritesParams,) => {
    return [
    `/organizations/getAllOrgFavorites`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrganizationsGetAllOrgFavoritesInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>>, TError = ErrorType<unknown>>(params?: GetOrganizationsGetAllOrgFavoritesParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsGetAllOrgFavoritesInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>> = ({ signal }) => getOrganizationsGetAllOrgFavorites(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsGetAllOrgFavoritesInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>>
export type GetOrganizationsGetAllOrgFavoritesInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsGetAllOrgFavoritesInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsGetAllOrgFavoritesParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsGetAllOrgFavoritesInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsGetAllOrgFavoritesParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsGetAllOrgFavoritesInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsGetAllOrgFavoritesParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsGetAllOrgFavoritesInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsGetAllOrgFavoritesParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsGetAllOrgFavoritesInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsGetAllOrgFavoritesInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsGetAllOrgFavoritesParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsGetAllOrgFavoritesInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsGetAllOrgFavoritesQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError = ErrorType<unknown>>(params?: GetOrganizationsGetAllOrgFavoritesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsGetAllOrgFavoritesQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>> = ({ signal }) => getOrganizationsGetAllOrgFavorites(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsGetAllOrgFavoritesQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>>
export type GetOrganizationsGetAllOrgFavoritesQueryError = ErrorType<unknown>


export function useGetOrganizationsGetAllOrgFavorites<TData = Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsGetAllOrgFavoritesParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsGetAllOrgFavorites<TData = Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsGetAllOrgFavoritesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsGetAllOrgFavorites<TData = Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsGetAllOrgFavoritesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsGetAllOrgFavorites<TData = Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsGetAllOrgFavoritesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsGetAllOrgFavoritesQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsGetAllOrgFavoritesQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsGetAllOrgFavoritesParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsGetAllOrgFavorites>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsGetAllOrgFavoritesQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getOrganizationsResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsResponseSuccess = (getOrganizationsResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsResponse = (getOrganizationsResponseSuccess)

export const getGetOrganizationsUrl = (params?: GetOrganizationsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organizations?${stringifiedParams}` : `/organizations`
}

export const getOrganizations = async (params?: GetOrganizationsParams, options?: RequestInit): Promise<getOrganizationsResponse> => {
  
  return useCustomClient<getOrganizationsResponse>(getGetOrganizationsUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsInfiniteQueryKey = (params?: GetOrganizationsParams,) => {
    return [
    'infinite', `/organizations`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrganizationsQueryKey = (params?: GetOrganizationsParams,) => {
    return [
    `/organizations`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrganizationsInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizations>>>, TError = ErrorType<unknown>>(params?: GetOrganizationsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizations>>> = ({ signal }) => getOrganizations(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizations>>>
export type GetOrganizationsInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizations>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizations>>,
          TError,
          Awaited<ReturnType<typeof getOrganizations>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizations>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizations>>,
          TError,
          Awaited<ReturnType<typeof getOrganizations>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizations>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizations>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizations>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizations>>, TError = ErrorType<unknown>>(params?: GetOrganizationsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizations>>> = ({ signal }) => getOrganizations(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizations>>>
export type GetOrganizationsQueryError = ErrorType<unknown>


export function useGetOrganizations<TData = Awaited<ReturnType<typeof getOrganizations>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizations>>,
          TError,
          Awaited<ReturnType<typeof getOrganizations>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizations<TData = Awaited<ReturnType<typeof getOrganizations>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizations>>,
          TError,
          Awaited<ReturnType<typeof getOrganizations>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizations<TData = Awaited<ReturnType<typeof getOrganizations>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizations<TData = Awaited<ReturnType<typeof getOrganizations>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsQuery = async <TData = Awaited<ReturnType<typeof getOrganizations>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizations>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postOrganizationsResponse200 = {
  data: Response
  status: 200
}
    
export type postOrganizationsResponseSuccess = (postOrganizationsResponse200) & {
  headers: Headers;
};
;

export type postOrganizationsResponse = (postOrganizationsResponseSuccess)

export const getPostOrganizationsUrl = () => {


  

  return `/organizations`
}

export const postOrganizations = async (organization: Organization[], options?: RequestInit): Promise<postOrganizationsResponse> => {
  
  return useCustomClient<postOrganizationsResponse>(getPostOrganizationsUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organization,)
  }
);}




export const getPostOrganizationsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizations>>, TError,{data: BodyType<Organization[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrganizations>>, TError,{data: BodyType<Organization[]>}, TContext> => {

const mutationKey = ['postOrganizations'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrganizations>>, {data: BodyType<Organization[]>}> = (props) => {
          const {data} = props ?? {};

          return  postOrganizations(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrganizationsMutationResult = NonNullable<Awaited<ReturnType<typeof postOrganizations>>>
    export type PostOrganizationsMutationBody = BodyType<Organization[]>
    export type PostOrganizationsMutationError = ErrorType<unknown>

    export const usePostOrganizations = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizations>>, TError,{data: BodyType<Organization[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrganizations>>,
        TError,
        {data: BodyType<Organization[]>},
        TContext
      > => {

      const mutationOptions = getPostOrganizationsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putOrganizationsResponse200 = {
  data: Response
  status: 200
}
    
export type putOrganizationsResponseSuccess = (putOrganizationsResponse200) & {
  headers: Headers;
};
;

export type putOrganizationsResponse = (putOrganizationsResponseSuccess)

export const getPutOrganizationsUrl = (params: PutOrganizationsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organizations?${stringifiedParams}` : `/organizations`
}

export const putOrganizations = async (organizationBody: OrganizationBody,
    params: PutOrganizationsParams, options?: RequestInit): Promise<putOrganizationsResponse> => {
  
  return useCustomClient<putOrganizationsResponse>(getPutOrganizationsUrl(params),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationBody,)
  }
);}




export const getPutOrganizationsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizations>>, TError,{data: BodyType<OrganizationBody>;params: PutOrganizationsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putOrganizations>>, TError,{data: BodyType<OrganizationBody>;params: PutOrganizationsParams}, TContext> => {

const mutationKey = ['putOrganizations'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putOrganizations>>, {data: BodyType<OrganizationBody>;params: PutOrganizationsParams}> = (props) => {
          const {data,params} = props ?? {};

          return  putOrganizations(data,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutOrganizationsMutationResult = NonNullable<Awaited<ReturnType<typeof putOrganizations>>>
    export type PutOrganizationsMutationBody = BodyType<OrganizationBody>
    export type PutOrganizationsMutationError = ErrorType<unknown>

    export const usePutOrganizations = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizations>>, TError,{data: BodyType<OrganizationBody>;params: PutOrganizationsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putOrganizations>>,
        TError,
        {data: BodyType<OrganizationBody>;params: PutOrganizationsParams},
        TContext
      > => {

      const mutationOptions = getPutOrganizationsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteOrganizationsResponse200 = {
  data: Response
  status: 200
}
    
export type deleteOrganizationsResponseSuccess = (deleteOrganizationsResponse200) & {
  headers: Headers;
};
;

export type deleteOrganizationsResponse = (deleteOrganizationsResponseSuccess)

export const getDeleteOrganizationsUrl = (params: DeleteOrganizationsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organizations?${stringifiedParams}` : `/organizations`
}

export const deleteOrganizations = async (params: DeleteOrganizationsParams, options?: RequestInit): Promise<deleteOrganizationsResponse> => {
  
  return useCustomClient<deleteOrganizationsResponse>(getDeleteOrganizationsUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteOrganizationsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizations>>, TError,{params: DeleteOrganizationsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizations>>, TError,{params: DeleteOrganizationsParams}, TContext> => {

const mutationKey = ['deleteOrganizations'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteOrganizations>>, {params: DeleteOrganizationsParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteOrganizations(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteOrganizationsMutationResult = NonNullable<Awaited<ReturnType<typeof deleteOrganizations>>>
    
    export type DeleteOrganizationsMutationError = ErrorType<unknown>

    export const useDeleteOrganizations = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizations>>, TError,{params: DeleteOrganizationsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteOrganizations>>,
        TError,
        {params: DeleteOrganizationsParams},
        TContext
      > => {

      const mutationOptions = getDeleteOrganizationsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrganizationsMyOrgResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsMyOrgResponseSuccess = (getOrganizationsMyOrgResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsMyOrgResponse = (getOrganizationsMyOrgResponseSuccess)

export const getGetOrganizationsMyOrgUrl = () => {


  

  return `/organizations/myOrg`
}

export const getOrganizationsMyOrg = async ( options?: RequestInit): Promise<getOrganizationsMyOrgResponse> => {
  
  return useCustomClient<getOrganizationsMyOrgResponse>(getGetOrganizationsMyOrgUrl(),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsMyOrgInfiniteQueryKey = () => {
    return [
    'infinite', `/organizations/myOrg`
    ] as const;
    }

export const getGetOrganizationsMyOrgQueryKey = () => {
    return [
    `/organizations/myOrg`
    ] as const;
    }

    
export const getGetOrganizationsMyOrgInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsMyOrg>>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsMyOrgInfiniteQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsMyOrg>>> = ({ signal }) => getOrganizationsMyOrg({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsMyOrgInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsMyOrg>>>
export type GetOrganizationsMyOrgInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsMyOrgInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsMyOrg>>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsMyOrg>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsMyOrg>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsMyOrgInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsMyOrg>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsMyOrg>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsMyOrg>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsMyOrgInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsMyOrg>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsMyOrgInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsMyOrg>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsMyOrgInfiniteQueryOptions(options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsMyOrgInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsMyOrgInfiniteQueryOptions(options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsMyOrgQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsMyOrgQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsMyOrg>>> = ({ signal }) => getOrganizationsMyOrg({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsMyOrgQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsMyOrg>>>
export type GetOrganizationsMyOrgQueryError = ErrorType<unknown>


export function useGetOrganizationsMyOrg<TData = Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsMyOrg>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsMyOrg>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsMyOrg<TData = Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsMyOrg>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsMyOrg>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsMyOrg<TData = Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsMyOrg<TData = Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsMyOrgQueryOptions(options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsMyOrgQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsMyOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsMyOrgQueryOptions(options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putOrganizationsMyOrgResponse200 = {
  data: Response
  status: 200
}
    
export type putOrganizationsMyOrgResponseSuccess = (putOrganizationsMyOrgResponse200) & {
  headers: Headers;
};
;

export type putOrganizationsMyOrgResponse = (putOrganizationsMyOrgResponseSuccess)

export const getPutOrganizationsMyOrgUrl = () => {


  

  return `/organizations/myOrg`
}

export const putOrganizationsMyOrg = async (putOrganizationsMyOrgBody: PutOrganizationsMyOrgBody, options?: RequestInit): Promise<putOrganizationsMyOrgResponse> => {
  
  return useCustomClient<putOrganizationsMyOrgResponse>(getPutOrganizationsMyOrgUrl(),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      putOrganizationsMyOrgBody,)
  }
);}




export const getPutOrganizationsMyOrgMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationsMyOrg>>, TError,{data: BodyType<PutOrganizationsMyOrgBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putOrganizationsMyOrg>>, TError,{data: BodyType<PutOrganizationsMyOrgBody>}, TContext> => {

const mutationKey = ['putOrganizationsMyOrg'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putOrganizationsMyOrg>>, {data: BodyType<PutOrganizationsMyOrgBody>}> = (props) => {
          const {data} = props ?? {};

          return  putOrganizationsMyOrg(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutOrganizationsMyOrgMutationResult = NonNullable<Awaited<ReturnType<typeof putOrganizationsMyOrg>>>
    export type PutOrganizationsMyOrgMutationBody = BodyType<PutOrganizationsMyOrgBody>
    export type PutOrganizationsMyOrgMutationError = ErrorType<unknown>

    export const usePutOrganizationsMyOrg = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationsMyOrg>>, TError,{data: BodyType<PutOrganizationsMyOrgBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putOrganizationsMyOrg>>,
        TError,
        {data: BodyType<PutOrganizationsMyOrgBody>},
        TContext
      > => {

      const mutationOptions = getPutOrganizationsMyOrgMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrganizationsSlugSlugResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsSlugSlugResponseSuccess = (getOrganizationsSlugSlugResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsSlugSlugResponse = (getOrganizationsSlugSlugResponseSuccess)

export const getGetOrganizationsSlugSlugUrl = (slug: string,) => {


  

  return `/organizations/slug/${slug}`
}

export const getOrganizationsSlugSlug = async (slug: string, options?: RequestInit): Promise<getOrganizationsSlugSlugResponse> => {
  
  return useCustomClient<getOrganizationsSlugSlugResponse>(getGetOrganizationsSlugSlugUrl(slug),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsSlugSlugInfiniteQueryKey = (slug?: string,) => {
    return [
    'infinite', `/organizations/slug/${slug}`
    ] as const;
    }

export const getGetOrganizationsSlugSlugQueryKey = (slug?: string,) => {
    return [
    `/organizations/slug/${slug}`
    ] as const;
    }

    
export const getGetOrganizationsSlugSlugInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>>, TError = ErrorType<unknown>>(slug: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsSlugSlugInfiniteQueryKey(slug);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>> = ({ signal }) => getOrganizationsSlugSlug(slug, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(slug),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsSlugSlugInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>>
export type GetOrganizationsSlugSlugInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsSlugSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>>, TError = ErrorType<unknown>>(
 slug: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsSlugSlug>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsSlugSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsSlugSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>>, TError = ErrorType<unknown>>(
 slug: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsSlugSlug>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsSlugSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsSlugSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>>, TError = ErrorType<unknown>>(
 slug: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsSlugSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>>, TError = ErrorType<unknown>>(
 slug: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsSlugSlugInfiniteQueryOptions(slug,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsSlugSlugInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, slug: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsSlugSlugInfiniteQueryOptions(slug,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsSlugSlugQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError = ErrorType<unknown>>(slug: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsSlugSlugQueryKey(slug);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>> = ({ signal }) => getOrganizationsSlugSlug(slug, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(slug),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsSlugSlugQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>>
export type GetOrganizationsSlugSlugQueryError = ErrorType<unknown>


export function useGetOrganizationsSlugSlug<TData = Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError = ErrorType<unknown>>(
 slug: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsSlugSlug>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsSlugSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsSlugSlug<TData = Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError = ErrorType<unknown>>(
 slug: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsSlugSlug>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsSlugSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsSlugSlug<TData = Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError = ErrorType<unknown>>(
 slug: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsSlugSlug<TData = Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError = ErrorType<unknown>>(
 slug: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsSlugSlugQueryOptions(slug,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsSlugSlugQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, slug: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsSlugSlugQueryOptions(slug,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getOrganizationsSlugGetAllSlugResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsSlugGetAllSlugResponseSuccess = (getOrganizationsSlugGetAllSlugResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsSlugGetAllSlugResponse = (getOrganizationsSlugGetAllSlugResponseSuccess)

export const getGetOrganizationsSlugGetAllSlugUrl = () => {


  

  return `/organizations/slug/getAllSlug`
}

export const getOrganizationsSlugGetAllSlug = async ( options?: RequestInit): Promise<getOrganizationsSlugGetAllSlugResponse> => {
  
  return useCustomClient<getOrganizationsSlugGetAllSlugResponse>(getGetOrganizationsSlugGetAllSlugUrl(),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsSlugGetAllSlugInfiniteQueryKey = () => {
    return [
    'infinite', `/organizations/slug/getAllSlug`
    ] as const;
    }

export const getGetOrganizationsSlugGetAllSlugQueryKey = () => {
    return [
    `/organizations/slug/getAllSlug`
    ] as const;
    }

    
export const getGetOrganizationsSlugGetAllSlugInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsSlugGetAllSlugInfiniteQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>> = ({ signal }) => getOrganizationsSlugGetAllSlug({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsSlugGetAllSlugInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>>
export type GetOrganizationsSlugGetAllSlugInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsSlugGetAllSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsSlugGetAllSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsSlugGetAllSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsSlugGetAllSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsSlugGetAllSlugInfiniteQueryOptions(options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsSlugGetAllSlugInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsSlugGetAllSlugInfiniteQueryOptions(options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsSlugGetAllSlugQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsSlugGetAllSlugQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>> = ({ signal }) => getOrganizationsSlugGetAllSlug({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsSlugGetAllSlugQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>>
export type GetOrganizationsSlugGetAllSlugQueryError = ErrorType<unknown>


export function useGetOrganizationsSlugGetAllSlug<TData = Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsSlugGetAllSlug<TData = Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsSlugGetAllSlug<TData = Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsSlugGetAllSlug<TData = Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsSlugGetAllSlugQueryOptions(options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsSlugGetAllSlugQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsSlugGetAllSlugQueryOptions(options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getOrganizationsValidationOrganizationIdResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsValidationOrganizationIdResponseSuccess = (getOrganizationsValidationOrganizationIdResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsValidationOrganizationIdResponse = (getOrganizationsValidationOrganizationIdResponseSuccess)

export const getGetOrganizationsValidationOrganizationIdUrl = (organizationId: string,) => {


  

  return `/organizations/validation/${organizationId}`
}

export const getOrganizationsValidationOrganizationId = async (organizationId: string, options?: RequestInit): Promise<getOrganizationsValidationOrganizationIdResponse> => {
  
  return useCustomClient<getOrganizationsValidationOrganizationIdResponse>(getGetOrganizationsValidationOrganizationIdUrl(organizationId),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsValidationOrganizationIdInfiniteQueryKey = (organizationId?: string,) => {
    return [
    'infinite', `/organizations/validation/${organizationId}`
    ] as const;
    }

export const getGetOrganizationsValidationOrganizationIdQueryKey = (organizationId?: string,) => {
    return [
    `/organizations/validation/${organizationId}`
    ] as const;
    }

    
export const getGetOrganizationsValidationOrganizationIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>>, TError = ErrorType<unknown>>(organizationId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsValidationOrganizationIdInfiniteQueryKey(organizationId);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>> = ({ signal }) => getOrganizationsValidationOrganizationId(organizationId, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(organizationId),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsValidationOrganizationIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>>
export type GetOrganizationsValidationOrganizationIdInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsValidationOrganizationIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>>, TError = ErrorType<unknown>>(
 organizationId: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsValidationOrganizationIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>>, TError = ErrorType<unknown>>(
 organizationId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsValidationOrganizationIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>>, TError = ErrorType<unknown>>(
 organizationId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsValidationOrganizationIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>>, TError = ErrorType<unknown>>(
 organizationId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsValidationOrganizationIdInfiniteQueryOptions(organizationId,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsValidationOrganizationIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, organizationId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsValidationOrganizationIdInfiniteQueryOptions(organizationId,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsValidationOrganizationIdQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError = ErrorType<unknown>>(organizationId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsValidationOrganizationIdQueryKey(organizationId);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>> = ({ signal }) => getOrganizationsValidationOrganizationId(organizationId, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(organizationId),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsValidationOrganizationIdQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>>
export type GetOrganizationsValidationOrganizationIdQueryError = ErrorType<unknown>


export function useGetOrganizationsValidationOrganizationId<TData = Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError = ErrorType<unknown>>(
 organizationId: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsValidationOrganizationId<TData = Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError = ErrorType<unknown>>(
 organizationId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsValidationOrganizationId<TData = Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError = ErrorType<unknown>>(
 organizationId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsValidationOrganizationId<TData = Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError = ErrorType<unknown>>(
 organizationId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsValidationOrganizationIdQueryOptions(organizationId,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsValidationOrganizationIdQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, organizationId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidationOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsValidationOrganizationIdQueryOptions(organizationId,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getOrganizationsValidationResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationsValidationResponseSuccess = (getOrganizationsValidationResponse200) & {
  headers: Headers;
};
;

export type getOrganizationsValidationResponse = (getOrganizationsValidationResponseSuccess)

export const getGetOrganizationsValidationUrl = (params?: GetOrganizationsValidationParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organizations/validation?${stringifiedParams}` : `/organizations/validation`
}

export const getOrganizationsValidation = async (params?: GetOrganizationsValidationParams, options?: RequestInit): Promise<getOrganizationsValidationResponse> => {
  
  return useCustomClient<getOrganizationsValidationResponse>(getGetOrganizationsValidationUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationsValidationInfiniteQueryKey = (params?: GetOrganizationsValidationParams,) => {
    return [
    'infinite', `/organizations/validation`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrganizationsValidationQueryKey = (params?: GetOrganizationsValidationParams,) => {
    return [
    `/organizations/validation`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrganizationsValidationInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsValidation>>>, TError = ErrorType<unknown>>(params?: GetOrganizationsValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsValidationInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsValidation>>> = ({ signal }) => getOrganizationsValidation(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsValidationInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsValidation>>>
export type GetOrganizationsValidationInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationsValidationInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsValidation>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsValidationParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsValidation>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsValidation>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsValidationInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsValidation>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsValidation>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsValidation>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsValidationInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsValidation>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsValidationInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationsValidation>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsValidationInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsValidationInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsValidation>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsValidationInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationsValidationQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationsValidation>>, TError = ErrorType<unknown>>(params?: GetOrganizationsValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationsValidationQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationsValidation>>> = ({ signal }) => getOrganizationsValidation(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationsValidationQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationsValidation>>>
export type GetOrganizationsValidationQueryError = ErrorType<unknown>


export function useGetOrganizationsValidation<TData = Awaited<ReturnType<typeof getOrganizationsValidation>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationsValidationParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsValidation>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsValidation>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsValidation<TData = Awaited<ReturnType<typeof getOrganizationsValidation>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationsValidation>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationsValidation>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationsValidation<TData = Awaited<ReturnType<typeof getOrganizationsValidation>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationsValidation<TData = Awaited<ReturnType<typeof getOrganizationsValidation>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationsValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationsValidationQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationsValidationQuery = async <TData = Awaited<ReturnType<typeof getOrganizationsValidation>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationsValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationsValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationsValidationQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postOrganizationsValidationResponse200 = {
  data: Response
  status: 200
}
    
export type postOrganizationsValidationResponseSuccess = (postOrganizationsValidationResponse200) & {
  headers: Headers;
};
;

export type postOrganizationsValidationResponse = (postOrganizationsValidationResponseSuccess)

export const getPostOrganizationsValidationUrl = () => {


  

  return `/organizations/validation`
}

export const postOrganizationsValidation = async (organizationValidationBody: OrganizationValidationBody, options?: RequestInit): Promise<postOrganizationsValidationResponse> => {
  
  return useCustomClient<postOrganizationsValidationResponse>(getPostOrganizationsValidationUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationValidationBody,)
  }
);}




export const getPostOrganizationsValidationMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsValidation>>, TError,{data: BodyType<OrganizationValidationBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsValidation>>, TError,{data: BodyType<OrganizationValidationBody>}, TContext> => {

const mutationKey = ['postOrganizationsValidation'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrganizationsValidation>>, {data: BodyType<OrganizationValidationBody>}> = (props) => {
          const {data} = props ?? {};

          return  postOrganizationsValidation(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrganizationsValidationMutationResult = NonNullable<Awaited<ReturnType<typeof postOrganizationsValidation>>>
    export type PostOrganizationsValidationMutationBody = BodyType<OrganizationValidationBody>
    export type PostOrganizationsValidationMutationError = ErrorType<unknown>

    export const usePostOrganizationsValidation = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationsValidation>>, TError,{data: BodyType<OrganizationValidationBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrganizationsValidation>>,
        TError,
        {data: BodyType<OrganizationValidationBody>},
        TContext
      > => {

      const mutationOptions = getPostOrganizationsValidationMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    