/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  DeleteScheduleParams,
  GetScheduleGetMyScheduleParams,
  GetScheduleGetScheduledTimeByEventEventIdParams,
  GetScheduleManageMyScheduleParams,
  OrganizationSchedule,
  Response
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Put
 */
export type putScheduleIdResponse200 = {
  data: Response
  status: 200
}
    
export type putScheduleIdResponseSuccess = (putScheduleIdResponse200) & {
  headers: Headers;
};
;

export type putScheduleIdResponse = (putScheduleIdResponseSuccess)

export const getPutScheduleIdUrl = (id: string,) => {


  

  return `/schedule/${id}`
}

export const putScheduleId = async (id: string,
    organizationSchedule: OrganizationSchedule, options?: RequestInit): Promise<putScheduleIdResponse> => {
  
  return useCustomClient<putScheduleIdResponse>(getPutScheduleIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationSchedule,)
  }
);}




export const getPutScheduleIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putScheduleId>>, TError,{id: string;data: BodyType<OrganizationSchedule>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putScheduleId>>, TError,{id: string;data: BodyType<OrganizationSchedule>}, TContext> => {

const mutationKey = ['putScheduleId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putScheduleId>>, {id: string;data: BodyType<OrganizationSchedule>}> = (props) => {
          const {id,data} = props ?? {};

          return  putScheduleId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutScheduleIdMutationResult = NonNullable<Awaited<ReturnType<typeof putScheduleId>>>
    export type PutScheduleIdMutationBody = BodyType<OrganizationSchedule>
    export type PutScheduleIdMutationError = ErrorType<unknown>

    export const usePutScheduleId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putScheduleId>>, TError,{id: string;data: BodyType<OrganizationSchedule>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putScheduleId>>,
        TError,
        {id: string;data: BodyType<OrganizationSchedule>},
        TContext
      > => {

      const mutationOptions = getPutScheduleIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteScheduleIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteScheduleIdResponseSuccess = (deleteScheduleIdResponse200) & {
  headers: Headers;
};
;

export type deleteScheduleIdResponse = (deleteScheduleIdResponseSuccess)

export const getDeleteScheduleIdUrl = (id: string,) => {


  

  return `/schedule/${id}`
}

export const deleteScheduleId = async (id: string, options?: RequestInit): Promise<deleteScheduleIdResponse> => {
  
  return useCustomClient<deleteScheduleIdResponse>(getDeleteScheduleIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteScheduleIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteScheduleId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteScheduleId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteScheduleId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteScheduleId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteScheduleId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteScheduleIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteScheduleId>>>
    
    export type DeleteScheduleIdMutationError = ErrorType<unknown>

    export const useDeleteScheduleId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteScheduleId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteScheduleId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteScheduleIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Post
 */
export type getScheduleGetMyScheduleResponse200 = {
  data: Response
  status: 200
}
    
export type getScheduleGetMyScheduleResponseSuccess = (getScheduleGetMyScheduleResponse200) & {
  headers: Headers;
};
;

export type getScheduleGetMyScheduleResponse = (getScheduleGetMyScheduleResponseSuccess)

export const getGetScheduleGetMyScheduleUrl = (params?: GetScheduleGetMyScheduleParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/schedule/getMySchedule?${stringifiedParams}` : `/schedule/getMySchedule`
}

export const getScheduleGetMySchedule = async (params?: GetScheduleGetMyScheduleParams, options?: RequestInit): Promise<getScheduleGetMyScheduleResponse> => {
  
  return useCustomClient<getScheduleGetMyScheduleResponse>(getGetScheduleGetMyScheduleUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetScheduleGetMyScheduleInfiniteQueryKey = (params?: GetScheduleGetMyScheduleParams,) => {
    return [
    'infinite', `/schedule/getMySchedule`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetScheduleGetMyScheduleQueryKey = (params?: GetScheduleGetMyScheduleParams,) => {
    return [
    `/schedule/getMySchedule`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetScheduleGetMyScheduleInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getScheduleGetMySchedule>>>, TError = ErrorType<unknown>>(params?: GetScheduleGetMyScheduleParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetScheduleGetMyScheduleInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getScheduleGetMySchedule>>> = ({ signal }) => getScheduleGetMySchedule(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetScheduleGetMyScheduleInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getScheduleGetMySchedule>>>
export type GetScheduleGetMyScheduleInfiniteQueryError = ErrorType<unknown>


export function useGetScheduleGetMyScheduleInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getScheduleGetMySchedule>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetScheduleGetMyScheduleParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getScheduleGetMySchedule>>,
          TError,
          Awaited<ReturnType<typeof getScheduleGetMySchedule>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetScheduleGetMyScheduleInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getScheduleGetMySchedule>>>, TError = ErrorType<unknown>>(
 params?: GetScheduleGetMyScheduleParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getScheduleGetMySchedule>>,
          TError,
          Awaited<ReturnType<typeof getScheduleGetMySchedule>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetScheduleGetMyScheduleInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getScheduleGetMySchedule>>>, TError = ErrorType<unknown>>(
 params?: GetScheduleGetMyScheduleParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetScheduleGetMyScheduleInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getScheduleGetMySchedule>>>, TError = ErrorType<unknown>>(
 params?: GetScheduleGetMyScheduleParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetScheduleGetMyScheduleInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetScheduleGetMyScheduleInfiniteQuery = async <TData = Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetScheduleGetMyScheduleParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetScheduleGetMyScheduleInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetScheduleGetMyScheduleQueryOptions = <TData = Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError = ErrorType<unknown>>(params?: GetScheduleGetMyScheduleParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetScheduleGetMyScheduleQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getScheduleGetMySchedule>>> = ({ signal }) => getScheduleGetMySchedule(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetScheduleGetMyScheduleQueryResult = NonNullable<Awaited<ReturnType<typeof getScheduleGetMySchedule>>>
export type GetScheduleGetMyScheduleQueryError = ErrorType<unknown>


export function useGetScheduleGetMySchedule<TData = Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError = ErrorType<unknown>>(
 params: undefined |  GetScheduleGetMyScheduleParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getScheduleGetMySchedule>>,
          TError,
          Awaited<ReturnType<typeof getScheduleGetMySchedule>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetScheduleGetMySchedule<TData = Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError = ErrorType<unknown>>(
 params?: GetScheduleGetMyScheduleParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getScheduleGetMySchedule>>,
          TError,
          Awaited<ReturnType<typeof getScheduleGetMySchedule>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetScheduleGetMySchedule<TData = Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError = ErrorType<unknown>>(
 params?: GetScheduleGetMyScheduleParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetScheduleGetMySchedule<TData = Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError = ErrorType<unknown>>(
 params?: GetScheduleGetMyScheduleParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetScheduleGetMyScheduleQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetScheduleGetMyScheduleQuery = async <TData = Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetScheduleGetMyScheduleParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetScheduleGetMyScheduleQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * get
 */
export type getScheduleGetScheduledTimeByEventEventIdResponse200 = {
  data: Response
  status: 200
}
    
export type getScheduleGetScheduledTimeByEventEventIdResponseSuccess = (getScheduleGetScheduledTimeByEventEventIdResponse200) & {
  headers: Headers;
};
;

export type getScheduleGetScheduledTimeByEventEventIdResponse = (getScheduleGetScheduledTimeByEventEventIdResponseSuccess)

export const getGetScheduleGetScheduledTimeByEventEventIdUrl = (eventId: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/schedule/getScheduledTimeByEvent/${eventId}?${stringifiedParams}` : `/schedule/getScheduledTimeByEvent/${eventId}`
}

export const getScheduleGetScheduledTimeByEventEventId = async (eventId: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams, options?: RequestInit): Promise<getScheduleGetScheduledTimeByEventEventIdResponse> => {
  
  return useCustomClient<getScheduleGetScheduledTimeByEventEventIdResponse>(getGetScheduleGetScheduledTimeByEventEventIdUrl(eventId,params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetScheduleGetScheduledTimeByEventEventIdInfiniteQueryKey = (eventId?: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams,) => {
    return [
    'infinite', `/schedule/getScheduledTimeByEvent/${eventId}`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetScheduleGetScheduledTimeByEventEventIdQueryKey = (eventId?: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams,) => {
    return [
    `/schedule/getScheduledTimeByEvent/${eventId}`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetScheduleGetScheduledTimeByEventEventIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>>, TError = ErrorType<unknown>>(eventId: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetScheduleGetScheduledTimeByEventEventIdInfiniteQueryKey(eventId,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>> = ({ signal }) => getScheduleGetScheduledTimeByEventEventId(eventId,params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(eventId),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetScheduleGetScheduledTimeByEventEventIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>>
export type GetScheduleGetScheduledTimeByEventEventIdInfiniteQueryError = ErrorType<unknown>


export function useGetScheduleGetScheduledTimeByEventEventIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>>, TError = ErrorType<unknown>>(
 eventId: string,
    params: undefined |  GetScheduleGetScheduledTimeByEventEventIdParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>,
          TError,
          Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetScheduleGetScheduledTimeByEventEventIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>>, TError = ErrorType<unknown>>(
 eventId: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>,
          TError,
          Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetScheduleGetScheduledTimeByEventEventIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>>, TError = ErrorType<unknown>>(
 eventId: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetScheduleGetScheduledTimeByEventEventIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>>, TError = ErrorType<unknown>>(
 eventId: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetScheduleGetScheduledTimeByEventEventIdInfiniteQueryOptions(eventId,params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetScheduleGetScheduledTimeByEventEventIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, eventId: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetScheduleGetScheduledTimeByEventEventIdInfiniteQueryOptions(eventId,params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetScheduleGetScheduledTimeByEventEventIdQueryOptions = <TData = Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError = ErrorType<unknown>>(eventId: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetScheduleGetScheduledTimeByEventEventIdQueryKey(eventId,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>> = ({ signal }) => getScheduleGetScheduledTimeByEventEventId(eventId,params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(eventId),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetScheduleGetScheduledTimeByEventEventIdQueryResult = NonNullable<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>>
export type GetScheduleGetScheduledTimeByEventEventIdQueryError = ErrorType<unknown>


export function useGetScheduleGetScheduledTimeByEventEventId<TData = Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError = ErrorType<unknown>>(
 eventId: string,
    params: undefined |  GetScheduleGetScheduledTimeByEventEventIdParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>,
          TError,
          Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetScheduleGetScheduledTimeByEventEventId<TData = Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError = ErrorType<unknown>>(
 eventId: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>,
          TError,
          Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetScheduleGetScheduledTimeByEventEventId<TData = Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError = ErrorType<unknown>>(
 eventId: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetScheduleGetScheduledTimeByEventEventId<TData = Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError = ErrorType<unknown>>(
 eventId: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetScheduleGetScheduledTimeByEventEventIdQueryOptions(eventId,params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetScheduleGetScheduledTimeByEventEventIdQuery = async <TData = Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, eventId: string,
    params?: GetScheduleGetScheduledTimeByEventEventIdParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleGetScheduledTimeByEventEventId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetScheduleGetScheduledTimeByEventEventIdQueryOptions(eventId,params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postScheduleResponse200 = {
  data: Response
  status: 200
}
    
export type postScheduleResponseSuccess = (postScheduleResponse200) & {
  headers: Headers;
};
;

export type postScheduleResponse = (postScheduleResponseSuccess)

export const getPostScheduleUrl = () => {


  

  return `/schedule`
}

export const postSchedule = async (organizationSchedule: OrganizationSchedule[], options?: RequestInit): Promise<postScheduleResponse> => {
  
  return useCustomClient<postScheduleResponse>(getPostScheduleUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationSchedule,)
  }
);}




export const getPostScheduleMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postSchedule>>, TError,{data: BodyType<OrganizationSchedule[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postSchedule>>, TError,{data: BodyType<OrganizationSchedule[]>}, TContext> => {

const mutationKey = ['postSchedule'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postSchedule>>, {data: BodyType<OrganizationSchedule[]>}> = (props) => {
          const {data} = props ?? {};

          return  postSchedule(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostScheduleMutationResult = NonNullable<Awaited<ReturnType<typeof postSchedule>>>
    export type PostScheduleMutationBody = BodyType<OrganizationSchedule[]>
    export type PostScheduleMutationError = ErrorType<unknown>

    export const usePostSchedule = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postSchedule>>, TError,{data: BodyType<OrganizationSchedule[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postSchedule>>,
        TError,
        {data: BodyType<OrganizationSchedule[]>},
        TContext
      > => {

      const mutationOptions = getPostScheduleMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteScheduleResponse200 = {
  data: Response
  status: 200
}
    
export type deleteScheduleResponseSuccess = (deleteScheduleResponse200) & {
  headers: Headers;
};
;

export type deleteScheduleResponse = (deleteScheduleResponseSuccess)

export const getDeleteScheduleUrl = (params: DeleteScheduleParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/schedule?${stringifiedParams}` : `/schedule`
}

export const deleteSchedule = async (params: DeleteScheduleParams, options?: RequestInit): Promise<deleteScheduleResponse> => {
  
  return useCustomClient<deleteScheduleResponse>(getDeleteScheduleUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteScheduleMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteSchedule>>, TError,{params: DeleteScheduleParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteSchedule>>, TError,{params: DeleteScheduleParams}, TContext> => {

const mutationKey = ['deleteSchedule'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteSchedule>>, {params: DeleteScheduleParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteSchedule(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteScheduleMutationResult = NonNullable<Awaited<ReturnType<typeof deleteSchedule>>>
    
    export type DeleteScheduleMutationError = ErrorType<unknown>

    export const useDeleteSchedule = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteSchedule>>, TError,{params: DeleteScheduleParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteSchedule>>,
        TError,
        {params: DeleteScheduleParams},
        TContext
      > => {

      const mutationOptions = getDeleteScheduleMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Post
 */
export type getScheduleManageMyScheduleResponse200 = {
  data: Response
  status: 200
}
    
export type getScheduleManageMyScheduleResponseSuccess = (getScheduleManageMyScheduleResponse200) & {
  headers: Headers;
};
;

export type getScheduleManageMyScheduleResponse = (getScheduleManageMyScheduleResponseSuccess)

export const getGetScheduleManageMyScheduleUrl = (params?: GetScheduleManageMyScheduleParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/schedule/manageMySchedule?${stringifiedParams}` : `/schedule/manageMySchedule`
}

export const getScheduleManageMySchedule = async (params?: GetScheduleManageMyScheduleParams, options?: RequestInit): Promise<getScheduleManageMyScheduleResponse> => {
  
  return useCustomClient<getScheduleManageMyScheduleResponse>(getGetScheduleManageMyScheduleUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetScheduleManageMyScheduleInfiniteQueryKey = (params?: GetScheduleManageMyScheduleParams,) => {
    return [
    'infinite', `/schedule/manageMySchedule`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetScheduleManageMyScheduleQueryKey = (params?: GetScheduleManageMyScheduleParams,) => {
    return [
    `/schedule/manageMySchedule`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetScheduleManageMyScheduleInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getScheduleManageMySchedule>>>, TError = ErrorType<unknown>>(params?: GetScheduleManageMyScheduleParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetScheduleManageMyScheduleInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getScheduleManageMySchedule>>> = ({ signal }) => getScheduleManageMySchedule(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetScheduleManageMyScheduleInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getScheduleManageMySchedule>>>
export type GetScheduleManageMyScheduleInfiniteQueryError = ErrorType<unknown>


export function useGetScheduleManageMyScheduleInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getScheduleManageMySchedule>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetScheduleManageMyScheduleParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getScheduleManageMySchedule>>,
          TError,
          Awaited<ReturnType<typeof getScheduleManageMySchedule>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetScheduleManageMyScheduleInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getScheduleManageMySchedule>>>, TError = ErrorType<unknown>>(
 params?: GetScheduleManageMyScheduleParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getScheduleManageMySchedule>>,
          TError,
          Awaited<ReturnType<typeof getScheduleManageMySchedule>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetScheduleManageMyScheduleInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getScheduleManageMySchedule>>>, TError = ErrorType<unknown>>(
 params?: GetScheduleManageMyScheduleParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetScheduleManageMyScheduleInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getScheduleManageMySchedule>>>, TError = ErrorType<unknown>>(
 params?: GetScheduleManageMyScheduleParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetScheduleManageMyScheduleInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetScheduleManageMyScheduleInfiniteQuery = async <TData = Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetScheduleManageMyScheduleParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetScheduleManageMyScheduleInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetScheduleManageMyScheduleQueryOptions = <TData = Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError = ErrorType<unknown>>(params?: GetScheduleManageMyScheduleParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetScheduleManageMyScheduleQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getScheduleManageMySchedule>>> = ({ signal }) => getScheduleManageMySchedule(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetScheduleManageMyScheduleQueryResult = NonNullable<Awaited<ReturnType<typeof getScheduleManageMySchedule>>>
export type GetScheduleManageMyScheduleQueryError = ErrorType<unknown>


export function useGetScheduleManageMySchedule<TData = Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError = ErrorType<unknown>>(
 params: undefined |  GetScheduleManageMyScheduleParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getScheduleManageMySchedule>>,
          TError,
          Awaited<ReturnType<typeof getScheduleManageMySchedule>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetScheduleManageMySchedule<TData = Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError = ErrorType<unknown>>(
 params?: GetScheduleManageMyScheduleParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getScheduleManageMySchedule>>,
          TError,
          Awaited<ReturnType<typeof getScheduleManageMySchedule>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetScheduleManageMySchedule<TData = Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError = ErrorType<unknown>>(
 params?: GetScheduleManageMyScheduleParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetScheduleManageMySchedule<TData = Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError = ErrorType<unknown>>(
 params?: GetScheduleManageMyScheduleParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetScheduleManageMyScheduleQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetScheduleManageMyScheduleQuery = async <TData = Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetScheduleManageMyScheduleParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getScheduleManageMySchedule>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetScheduleManageMyScheduleQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



