/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  DeleteOrganizationCategoryParams,
  DeleteOrganizationCategorySubParams,
  GetOrganizationCategoryOrgsParams,
  GetOrganizationCategoryParams,
  GetOrganizationCategorySubParams,
  OrganizationCategory,
  OrganizationCategoryBody,
  OrganizationCategorySub,
  OrganizationCategorySubBody,
  PutOrganizationCategoryParams,
  PutOrganizationCategorySubParams,
  Response
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Get
 */
export type getOrganizationCategoryIdResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationCategoryIdResponseSuccess = (getOrganizationCategoryIdResponse200) & {
  headers: Headers;
};
;

export type getOrganizationCategoryIdResponse = (getOrganizationCategoryIdResponseSuccess)

export const getGetOrganizationCategoryIdUrl = (id: string,) => {


  

  return `/organization_category/${id}`
}

export const getOrganizationCategoryId = async (id: string, options?: RequestInit): Promise<getOrganizationCategoryIdResponse> => {
  
  return useCustomClient<getOrganizationCategoryIdResponse>(getGetOrganizationCategoryIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationCategoryIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/organization_category/${id}`
    ] as const;
    }

export const getGetOrganizationCategoryIdQueryKey = (id?: string,) => {
    return [
    `/organization_category/${id}`
    ] as const;
    }

    
export const getGetOrganizationCategoryIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategoryId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationCategoryIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationCategoryId>>> = ({ signal }) => getOrganizationCategoryId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationCategoryIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationCategoryId>>>
export type GetOrganizationCategoryIdInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationCategoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategoryId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategoryId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategoryId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategoryId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategoryId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationCategoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategoryId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationCategoryIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationCategoryIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationCategoryIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationCategoryIdQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationCategoryIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationCategoryId>>> = ({ signal }) => getOrganizationCategoryId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationCategoryIdQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationCategoryId>>>
export type GetOrganizationCategoryIdQueryError = ErrorType<unknown>


export function useGetOrganizationCategoryId<TData = Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategoryId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategoryId<TData = Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategoryId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategoryId<TData = Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationCategoryId<TData = Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationCategoryIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationCategoryIdQuery = async <TData = Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationCategoryIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putOrganizationCategoryIdResponse200 = {
  data: Response
  status: 200
}
    
export type putOrganizationCategoryIdResponseSuccess = (putOrganizationCategoryIdResponse200) & {
  headers: Headers;
};
;

export type putOrganizationCategoryIdResponse = (putOrganizationCategoryIdResponseSuccess)

export const getPutOrganizationCategoryIdUrl = (id: string,) => {


  

  return `/organization_category/${id}`
}

export const putOrganizationCategoryId = async (id: string,
    organizationCategoryBody: OrganizationCategoryBody, options?: RequestInit): Promise<putOrganizationCategoryIdResponse> => {
  
  return useCustomClient<putOrganizationCategoryIdResponse>(getPutOrganizationCategoryIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationCategoryBody,)
  }
);}




export const getPutOrganizationCategoryIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationCategoryId>>, TError,{id: string;data: BodyType<OrganizationCategoryBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putOrganizationCategoryId>>, TError,{id: string;data: BodyType<OrganizationCategoryBody>}, TContext> => {

const mutationKey = ['putOrganizationCategoryId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putOrganizationCategoryId>>, {id: string;data: BodyType<OrganizationCategoryBody>}> = (props) => {
          const {id,data} = props ?? {};

          return  putOrganizationCategoryId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutOrganizationCategoryIdMutationResult = NonNullable<Awaited<ReturnType<typeof putOrganizationCategoryId>>>
    export type PutOrganizationCategoryIdMutationBody = BodyType<OrganizationCategoryBody>
    export type PutOrganizationCategoryIdMutationError = ErrorType<unknown>

    export const usePutOrganizationCategoryId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationCategoryId>>, TError,{id: string;data: BodyType<OrganizationCategoryBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putOrganizationCategoryId>>,
        TError,
        {id: string;data: BodyType<OrganizationCategoryBody>},
        TContext
      > => {

      const mutationOptions = getPutOrganizationCategoryIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteOrganizationCategoryIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteOrganizationCategoryIdResponseSuccess = (deleteOrganizationCategoryIdResponse200) & {
  headers: Headers;
};
;

export type deleteOrganizationCategoryIdResponse = (deleteOrganizationCategoryIdResponseSuccess)

export const getDeleteOrganizationCategoryIdUrl = (id: string,) => {


  

  return `/organization_category/${id}`
}

export const deleteOrganizationCategoryId = async (id: string, options?: RequestInit): Promise<deleteOrganizationCategoryIdResponse> => {
  
  return useCustomClient<deleteOrganizationCategoryIdResponse>(getDeleteOrganizationCategoryIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteOrganizationCategoryIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationCategoryId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationCategoryId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteOrganizationCategoryId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteOrganizationCategoryId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteOrganizationCategoryId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteOrganizationCategoryIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteOrganizationCategoryId>>>
    
    export type DeleteOrganizationCategoryIdMutationError = ErrorType<unknown>

    export const useDeleteOrganizationCategoryId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationCategoryId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteOrganizationCategoryId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteOrganizationCategoryIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrganizationCategoryResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationCategoryResponseSuccess = (getOrganizationCategoryResponse200) & {
  headers: Headers;
};
;

export type getOrganizationCategoryResponse = (getOrganizationCategoryResponseSuccess)

export const getGetOrganizationCategoryUrl = (params?: GetOrganizationCategoryParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organization_category?${stringifiedParams}` : `/organization_category`
}

export const getOrganizationCategory = async (params?: GetOrganizationCategoryParams, options?: RequestInit): Promise<getOrganizationCategoryResponse> => {
  
  return useCustomClient<getOrganizationCategoryResponse>(getGetOrganizationCategoryUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationCategoryInfiniteQueryKey = (params?: GetOrganizationCategoryParams,) => {
    return [
    'infinite', `/organization_category`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrganizationCategoryQueryKey = (params?: GetOrganizationCategoryParams,) => {
    return [
    `/organization_category`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrganizationCategoryInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategory>>>, TError = ErrorType<unknown>>(params?: GetOrganizationCategoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationCategoryInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationCategory>>> = ({ signal }) => getOrganizationCategory(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationCategoryInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationCategory>>>
export type GetOrganizationCategoryInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationCategoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategory>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationCategoryParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategory>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategory>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategory>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategory>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationCategoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategory>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationCategoryInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationCategoryInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationCategory>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationCategoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationCategoryInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationCategoryQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationCategory>>, TError = ErrorType<unknown>>(params?: GetOrganizationCategoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationCategoryQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationCategory>>> = ({ signal }) => getOrganizationCategory(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationCategoryQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationCategory>>>
export type GetOrganizationCategoryQueryError = ErrorType<unknown>


export function useGetOrganizationCategory<TData = Awaited<ReturnType<typeof getOrganizationCategory>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationCategoryParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategory>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategory<TData = Awaited<ReturnType<typeof getOrganizationCategory>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategory>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategory<TData = Awaited<ReturnType<typeof getOrganizationCategory>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationCategory<TData = Awaited<ReturnType<typeof getOrganizationCategory>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationCategoryQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationCategoryQuery = async <TData = Awaited<ReturnType<typeof getOrganizationCategory>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationCategoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationCategoryQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postOrganizationCategoryResponse200 = {
  data: Response
  status: 200
}
    
export type postOrganizationCategoryResponseSuccess = (postOrganizationCategoryResponse200) & {
  headers: Headers;
};
;

export type postOrganizationCategoryResponse = (postOrganizationCategoryResponseSuccess)

export const getPostOrganizationCategoryUrl = () => {


  

  return `/organization_category`
}

export const postOrganizationCategory = async (organizationCategory: OrganizationCategory[], options?: RequestInit): Promise<postOrganizationCategoryResponse> => {
  
  return useCustomClient<postOrganizationCategoryResponse>(getPostOrganizationCategoryUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationCategory,)
  }
);}




export const getPostOrganizationCategoryMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationCategory>>, TError,{data: BodyType<OrganizationCategory[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrganizationCategory>>, TError,{data: BodyType<OrganizationCategory[]>}, TContext> => {

const mutationKey = ['postOrganizationCategory'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrganizationCategory>>, {data: BodyType<OrganizationCategory[]>}> = (props) => {
          const {data} = props ?? {};

          return  postOrganizationCategory(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrganizationCategoryMutationResult = NonNullable<Awaited<ReturnType<typeof postOrganizationCategory>>>
    export type PostOrganizationCategoryMutationBody = BodyType<OrganizationCategory[]>
    export type PostOrganizationCategoryMutationError = ErrorType<unknown>

    export const usePostOrganizationCategory = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationCategory>>, TError,{data: BodyType<OrganizationCategory[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrganizationCategory>>,
        TError,
        {data: BodyType<OrganizationCategory[]>},
        TContext
      > => {

      const mutationOptions = getPostOrganizationCategoryMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putOrganizationCategoryResponse200 = {
  data: Response
  status: 200
}
    
export type putOrganizationCategoryResponseSuccess = (putOrganizationCategoryResponse200) & {
  headers: Headers;
};
;

export type putOrganizationCategoryResponse = (putOrganizationCategoryResponseSuccess)

export const getPutOrganizationCategoryUrl = (params: PutOrganizationCategoryParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organization_category?${stringifiedParams}` : `/organization_category`
}

export const putOrganizationCategory = async (organizationCategoryBody: OrganizationCategoryBody,
    params: PutOrganizationCategoryParams, options?: RequestInit): Promise<putOrganizationCategoryResponse> => {
  
  return useCustomClient<putOrganizationCategoryResponse>(getPutOrganizationCategoryUrl(params),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationCategoryBody,)
  }
);}




export const getPutOrganizationCategoryMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationCategory>>, TError,{data: BodyType<OrganizationCategoryBody>;params: PutOrganizationCategoryParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putOrganizationCategory>>, TError,{data: BodyType<OrganizationCategoryBody>;params: PutOrganizationCategoryParams}, TContext> => {

const mutationKey = ['putOrganizationCategory'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putOrganizationCategory>>, {data: BodyType<OrganizationCategoryBody>;params: PutOrganizationCategoryParams}> = (props) => {
          const {data,params} = props ?? {};

          return  putOrganizationCategory(data,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutOrganizationCategoryMutationResult = NonNullable<Awaited<ReturnType<typeof putOrganizationCategory>>>
    export type PutOrganizationCategoryMutationBody = BodyType<OrganizationCategoryBody>
    export type PutOrganizationCategoryMutationError = ErrorType<unknown>

    export const usePutOrganizationCategory = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationCategory>>, TError,{data: BodyType<OrganizationCategoryBody>;params: PutOrganizationCategoryParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putOrganizationCategory>>,
        TError,
        {data: BodyType<OrganizationCategoryBody>;params: PutOrganizationCategoryParams},
        TContext
      > => {

      const mutationOptions = getPutOrganizationCategoryMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteOrganizationCategoryResponse200 = {
  data: Response
  status: 200
}
    
export type deleteOrganizationCategoryResponseSuccess = (deleteOrganizationCategoryResponse200) & {
  headers: Headers;
};
;

export type deleteOrganizationCategoryResponse = (deleteOrganizationCategoryResponseSuccess)

export const getDeleteOrganizationCategoryUrl = (params: DeleteOrganizationCategoryParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organization_category?${stringifiedParams}` : `/organization_category`
}

export const deleteOrganizationCategory = async (params: DeleteOrganizationCategoryParams, options?: RequestInit): Promise<deleteOrganizationCategoryResponse> => {
  
  return useCustomClient<deleteOrganizationCategoryResponse>(getDeleteOrganizationCategoryUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteOrganizationCategoryMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationCategory>>, TError,{params: DeleteOrganizationCategoryParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationCategory>>, TError,{params: DeleteOrganizationCategoryParams}, TContext> => {

const mutationKey = ['deleteOrganizationCategory'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteOrganizationCategory>>, {params: DeleteOrganizationCategoryParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteOrganizationCategory(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteOrganizationCategoryMutationResult = NonNullable<Awaited<ReturnType<typeof deleteOrganizationCategory>>>
    
    export type DeleteOrganizationCategoryMutationError = ErrorType<unknown>

    export const useDeleteOrganizationCategory = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationCategory>>, TError,{params: DeleteOrganizationCategoryParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteOrganizationCategory>>,
        TError,
        {params: DeleteOrganizationCategoryParams},
        TContext
      > => {

      const mutationOptions = getDeleteOrganizationCategoryMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrganizationCategoryOrgsResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationCategoryOrgsResponseSuccess = (getOrganizationCategoryOrgsResponse200) & {
  headers: Headers;
};
;

export type getOrganizationCategoryOrgsResponse = (getOrganizationCategoryOrgsResponseSuccess)

export const getGetOrganizationCategoryOrgsUrl = (params?: GetOrganizationCategoryOrgsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organization_category/orgs?${stringifiedParams}` : `/organization_category/orgs`
}

export const getOrganizationCategoryOrgs = async (params?: GetOrganizationCategoryOrgsParams, options?: RequestInit): Promise<getOrganizationCategoryOrgsResponse> => {
  
  return useCustomClient<getOrganizationCategoryOrgsResponse>(getGetOrganizationCategoryOrgsUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationCategoryOrgsInfiniteQueryKey = (params?: GetOrganizationCategoryOrgsParams,) => {
    return [
    'infinite', `/organization_category/orgs`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrganizationCategoryOrgsQueryKey = (params?: GetOrganizationCategoryOrgsParams,) => {
    return [
    `/organization_category/orgs`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrganizationCategoryOrgsInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>>, TError = ErrorType<unknown>>(params?: GetOrganizationCategoryOrgsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationCategoryOrgsInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>> = ({ signal }) => getOrganizationCategoryOrgs(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationCategoryOrgsInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>>
export type GetOrganizationCategoryOrgsInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationCategoryOrgsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationCategoryOrgsParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategoryOrgsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategoryOrgsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategoryOrgsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategoryOrgsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationCategoryOrgsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategoryOrgsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationCategoryOrgsInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationCategoryOrgsInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationCategoryOrgsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationCategoryOrgsInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationCategoryOrgsQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError = ErrorType<unknown>>(params?: GetOrganizationCategoryOrgsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationCategoryOrgsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>> = ({ signal }) => getOrganizationCategoryOrgs(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationCategoryOrgsQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>>
export type GetOrganizationCategoryOrgsQueryError = ErrorType<unknown>


export function useGetOrganizationCategoryOrgs<TData = Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationCategoryOrgsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategoryOrgs<TData = Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategoryOrgsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategoryOrgs<TData = Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategoryOrgsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationCategoryOrgs<TData = Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategoryOrgsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationCategoryOrgsQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationCategoryOrgsQuery = async <TData = Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationCategoryOrgsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategoryOrgs>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationCategoryOrgsQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getOrganizationCategorySubIdResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationCategorySubIdResponseSuccess = (getOrganizationCategorySubIdResponse200) & {
  headers: Headers;
};
;

export type getOrganizationCategorySubIdResponse = (getOrganizationCategorySubIdResponseSuccess)

export const getGetOrganizationCategorySubIdUrl = (id: string,) => {


  

  return `/organization_category/sub/${id}`
}

export const getOrganizationCategorySubId = async (id: string, options?: RequestInit): Promise<getOrganizationCategorySubIdResponse> => {
  
  return useCustomClient<getOrganizationCategorySubIdResponse>(getGetOrganizationCategorySubIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationCategorySubIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/organization_category/sub/${id}`
    ] as const;
    }

export const getGetOrganizationCategorySubIdQueryKey = (id?: string,) => {
    return [
    `/organization_category/sub/${id}`
    ] as const;
    }

    
export const getGetOrganizationCategorySubIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategorySubId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationCategorySubIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationCategorySubId>>> = ({ signal }) => getOrganizationCategorySubId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationCategorySubIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationCategorySubId>>>
export type GetOrganizationCategorySubIdInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationCategorySubIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategorySubId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategorySubId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategorySubId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategorySubIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategorySubId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategorySubId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategorySubId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategorySubIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategorySubId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationCategorySubIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategorySubId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationCategorySubIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationCategorySubIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationCategorySubIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationCategorySubIdQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationCategorySubIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationCategorySubId>>> = ({ signal }) => getOrganizationCategorySubId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationCategorySubIdQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationCategorySubId>>>
export type GetOrganizationCategorySubIdQueryError = ErrorType<unknown>


export function useGetOrganizationCategorySubId<TData = Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategorySubId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategorySubId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategorySubId<TData = Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategorySubId>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategorySubId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategorySubId<TData = Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationCategorySubId<TData = Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationCategorySubIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationCategorySubIdQuery = async <TData = Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySubId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationCategorySubIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putOrganizationCategorySubIdResponse200 = {
  data: Response
  status: 200
}
    
export type putOrganizationCategorySubIdResponseSuccess = (putOrganizationCategorySubIdResponse200) & {
  headers: Headers;
};
;

export type putOrganizationCategorySubIdResponse = (putOrganizationCategorySubIdResponseSuccess)

export const getPutOrganizationCategorySubIdUrl = (id: string,) => {


  

  return `/organization_category/sub/${id}`
}

export const putOrganizationCategorySubId = async (id: string,
    organizationCategorySubBody: OrganizationCategorySubBody, options?: RequestInit): Promise<putOrganizationCategorySubIdResponse> => {
  
  return useCustomClient<putOrganizationCategorySubIdResponse>(getPutOrganizationCategorySubIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationCategorySubBody,)
  }
);}




export const getPutOrganizationCategorySubIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationCategorySubId>>, TError,{id: string;data: BodyType<OrganizationCategorySubBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putOrganizationCategorySubId>>, TError,{id: string;data: BodyType<OrganizationCategorySubBody>}, TContext> => {

const mutationKey = ['putOrganizationCategorySubId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putOrganizationCategorySubId>>, {id: string;data: BodyType<OrganizationCategorySubBody>}> = (props) => {
          const {id,data} = props ?? {};

          return  putOrganizationCategorySubId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutOrganizationCategorySubIdMutationResult = NonNullable<Awaited<ReturnType<typeof putOrganizationCategorySubId>>>
    export type PutOrganizationCategorySubIdMutationBody = BodyType<OrganizationCategorySubBody>
    export type PutOrganizationCategorySubIdMutationError = ErrorType<unknown>

    export const usePutOrganizationCategorySubId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationCategorySubId>>, TError,{id: string;data: BodyType<OrganizationCategorySubBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putOrganizationCategorySubId>>,
        TError,
        {id: string;data: BodyType<OrganizationCategorySubBody>},
        TContext
      > => {

      const mutationOptions = getPutOrganizationCategorySubIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteOrganizationCategorySubIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteOrganizationCategorySubIdResponseSuccess = (deleteOrganizationCategorySubIdResponse200) & {
  headers: Headers;
};
;

export type deleteOrganizationCategorySubIdResponse = (deleteOrganizationCategorySubIdResponseSuccess)

export const getDeleteOrganizationCategorySubIdUrl = (id: string,) => {


  

  return `/organization_category/sub/${id}`
}

export const deleteOrganizationCategorySubId = async (id: string, options?: RequestInit): Promise<deleteOrganizationCategorySubIdResponse> => {
  
  return useCustomClient<deleteOrganizationCategorySubIdResponse>(getDeleteOrganizationCategorySubIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteOrganizationCategorySubIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationCategorySubId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationCategorySubId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteOrganizationCategorySubId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteOrganizationCategorySubId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteOrganizationCategorySubId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteOrganizationCategorySubIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteOrganizationCategorySubId>>>
    
    export type DeleteOrganizationCategorySubIdMutationError = ErrorType<unknown>

    export const useDeleteOrganizationCategorySubId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationCategorySubId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteOrganizationCategorySubId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteOrganizationCategorySubIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getOrganizationCategorySubResponse200 = {
  data: Response
  status: 200
}
    
export type getOrganizationCategorySubResponseSuccess = (getOrganizationCategorySubResponse200) & {
  headers: Headers;
};
;

export type getOrganizationCategorySubResponse = (getOrganizationCategorySubResponseSuccess)

export const getGetOrganizationCategorySubUrl = (params?: GetOrganizationCategorySubParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organization_category/sub?${stringifiedParams}` : `/organization_category/sub`
}

export const getOrganizationCategorySub = async (params?: GetOrganizationCategorySubParams, options?: RequestInit): Promise<getOrganizationCategorySubResponse> => {
  
  return useCustomClient<getOrganizationCategorySubResponse>(getGetOrganizationCategorySubUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetOrganizationCategorySubInfiniteQueryKey = (params?: GetOrganizationCategorySubParams,) => {
    return [
    'infinite', `/organization_category/sub`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetOrganizationCategorySubQueryKey = (params?: GetOrganizationCategorySubParams,) => {
    return [
    `/organization_category/sub`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetOrganizationCategorySubInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategorySub>>>, TError = ErrorType<unknown>>(params?: GetOrganizationCategorySubParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationCategorySubInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationCategorySub>>> = ({ signal }) => getOrganizationCategorySub(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationCategorySubInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationCategorySub>>>
export type GetOrganizationCategorySubInfiniteQueryError = ErrorType<unknown>


export function useGetOrganizationCategorySubInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategorySub>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationCategorySubParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategorySub>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategorySub>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategorySubInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategorySub>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategorySubParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategorySub>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategorySub>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategorySubInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategorySub>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategorySubParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationCategorySubInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getOrganizationCategorySub>>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategorySubParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationCategorySubInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationCategorySubInfiniteQuery = async <TData = Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationCategorySubParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationCategorySubInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetOrganizationCategorySubQueryOptions = <TData = Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError = ErrorType<unknown>>(params?: GetOrganizationCategorySubParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetOrganizationCategorySubQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getOrganizationCategorySub>>> = ({ signal }) => getOrganizationCategorySub(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetOrganizationCategorySubQueryResult = NonNullable<Awaited<ReturnType<typeof getOrganizationCategorySub>>>
export type GetOrganizationCategorySubQueryError = ErrorType<unknown>


export function useGetOrganizationCategorySub<TData = Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError = ErrorType<unknown>>(
 params: undefined |  GetOrganizationCategorySubParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategorySub>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategorySub>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategorySub<TData = Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategorySubParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getOrganizationCategorySub>>,
          TError,
          Awaited<ReturnType<typeof getOrganizationCategorySub>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetOrganizationCategorySub<TData = Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategorySubParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetOrganizationCategorySub<TData = Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError = ErrorType<unknown>>(
 params?: GetOrganizationCategorySubParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetOrganizationCategorySubQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetOrganizationCategorySubQuery = async <TData = Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetOrganizationCategorySubParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getOrganizationCategorySub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetOrganizationCategorySubQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postOrganizationCategorySubResponse200 = {
  data: Response
  status: 200
}
    
export type postOrganizationCategorySubResponseSuccess = (postOrganizationCategorySubResponse200) & {
  headers: Headers;
};
;

export type postOrganizationCategorySubResponse = (postOrganizationCategorySubResponseSuccess)

export const getPostOrganizationCategorySubUrl = () => {


  

  return `/organization_category/sub`
}

export const postOrganizationCategorySub = async (organizationCategorySub: OrganizationCategorySub[], options?: RequestInit): Promise<postOrganizationCategorySubResponse> => {
  
  return useCustomClient<postOrganizationCategorySubResponse>(getPostOrganizationCategorySubUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationCategorySub,)
  }
);}




export const getPostOrganizationCategorySubMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationCategorySub>>, TError,{data: BodyType<OrganizationCategorySub[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postOrganizationCategorySub>>, TError,{data: BodyType<OrganizationCategorySub[]>}, TContext> => {

const mutationKey = ['postOrganizationCategorySub'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postOrganizationCategorySub>>, {data: BodyType<OrganizationCategorySub[]>}> = (props) => {
          const {data} = props ?? {};

          return  postOrganizationCategorySub(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostOrganizationCategorySubMutationResult = NonNullable<Awaited<ReturnType<typeof postOrganizationCategorySub>>>
    export type PostOrganizationCategorySubMutationBody = BodyType<OrganizationCategorySub[]>
    export type PostOrganizationCategorySubMutationError = ErrorType<unknown>

    export const usePostOrganizationCategorySub = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postOrganizationCategorySub>>, TError,{data: BodyType<OrganizationCategorySub[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postOrganizationCategorySub>>,
        TError,
        {data: BodyType<OrganizationCategorySub[]>},
        TContext
      > => {

      const mutationOptions = getPostOrganizationCategorySubMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putOrganizationCategorySubResponse200 = {
  data: Response
  status: 200
}
    
export type putOrganizationCategorySubResponseSuccess = (putOrganizationCategorySubResponse200) & {
  headers: Headers;
};
;

export type putOrganizationCategorySubResponse = (putOrganizationCategorySubResponseSuccess)

export const getPutOrganizationCategorySubUrl = (params: PutOrganizationCategorySubParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organization_category/sub?${stringifiedParams}` : `/organization_category/sub`
}

export const putOrganizationCategorySub = async (organizationCategorySubBody: OrganizationCategorySubBody,
    params: PutOrganizationCategorySubParams, options?: RequestInit): Promise<putOrganizationCategorySubResponse> => {
  
  return useCustomClient<putOrganizationCategorySubResponse>(getPutOrganizationCategorySubUrl(params),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      organizationCategorySubBody,)
  }
);}




export const getPutOrganizationCategorySubMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationCategorySub>>, TError,{data: BodyType<OrganizationCategorySubBody>;params: PutOrganizationCategorySubParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putOrganizationCategorySub>>, TError,{data: BodyType<OrganizationCategorySubBody>;params: PutOrganizationCategorySubParams}, TContext> => {

const mutationKey = ['putOrganizationCategorySub'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putOrganizationCategorySub>>, {data: BodyType<OrganizationCategorySubBody>;params: PutOrganizationCategorySubParams}> = (props) => {
          const {data,params} = props ?? {};

          return  putOrganizationCategorySub(data,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutOrganizationCategorySubMutationResult = NonNullable<Awaited<ReturnType<typeof putOrganizationCategorySub>>>
    export type PutOrganizationCategorySubMutationBody = BodyType<OrganizationCategorySubBody>
    export type PutOrganizationCategorySubMutationError = ErrorType<unknown>

    export const usePutOrganizationCategorySub = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putOrganizationCategorySub>>, TError,{data: BodyType<OrganizationCategorySubBody>;params: PutOrganizationCategorySubParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putOrganizationCategorySub>>,
        TError,
        {data: BodyType<OrganizationCategorySubBody>;params: PutOrganizationCategorySubParams},
        TContext
      > => {

      const mutationOptions = getPutOrganizationCategorySubMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteOrganizationCategorySubResponse200 = {
  data: Response
  status: 200
}
    
export type deleteOrganizationCategorySubResponseSuccess = (deleteOrganizationCategorySubResponse200) & {
  headers: Headers;
};
;

export type deleteOrganizationCategorySubResponse = (deleteOrganizationCategorySubResponseSuccess)

export const getDeleteOrganizationCategorySubUrl = (params: DeleteOrganizationCategorySubParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/organization_category/sub?${stringifiedParams}` : `/organization_category/sub`
}

export const deleteOrganizationCategorySub = async (params: DeleteOrganizationCategorySubParams, options?: RequestInit): Promise<deleteOrganizationCategorySubResponse> => {
  
  return useCustomClient<deleteOrganizationCategorySubResponse>(getDeleteOrganizationCategorySubUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteOrganizationCategorySubMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationCategorySub>>, TError,{params: DeleteOrganizationCategorySubParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationCategorySub>>, TError,{params: DeleteOrganizationCategorySubParams}, TContext> => {

const mutationKey = ['deleteOrganizationCategorySub'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteOrganizationCategorySub>>, {params: DeleteOrganizationCategorySubParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteOrganizationCategorySub(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteOrganizationCategorySubMutationResult = NonNullable<Awaited<ReturnType<typeof deleteOrganizationCategorySub>>>
    
    export type DeleteOrganizationCategorySubMutationError = ErrorType<unknown>

    export const useDeleteOrganizationCategorySub = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteOrganizationCategorySub>>, TError,{params: DeleteOrganizationCategorySubParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteOrganizationCategorySub>>,
        TError,
        {params: DeleteOrganizationCategorySubParams},
        TContext
      > => {

      const mutationOptions = getDeleteOrganizationCategorySubMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    